using System;
using System.IO;

namespace Bertaccini.Utils
{
	public class SRead
	{
		public static string ReadLine(Stream s)
		{
			//Trace.WriteLine("Reading stream");
			string res = "";
			char i;
			do
			{
				int u = s.ReadByte();
				i = (char) u;
				//Trace.WriteLine("Read " + u.ToString() + " = " + i);
				if(i == '\n')
					return res.Substring(0,res.Length-1);
				res = res + i;
			}while (true);
		}

//		public static byte[] String2Bytes(string s)
//		{
//			byte[] res = new byte[s.Length*2];
//			for (int i = 0; i < s.Length;i++)
//			{
//				int c = s[i];
//				res[i*2] = (byte) ((c & 0xFF00)>>8);
//				res[i*2+1] = (byte) (c & 0x00FF);
//			}
//			return res;
//		}
//
//		public static string Bytes2String(byte[] b)
//		{
//			System.Text.StringBuilder sb = new System.Text.StringBuilder(b.Length/2);
//			for(int i = 0; i < b.Length; i+=2)
//			{
//				int c = (((int)b[i]) << 8) + b[i+1];
//				sb.Append((char)c);
//			}
//			return sb.ToString();
//		}
	}

	public class DoubleStream : Stream
	{
		MemoryStream mem = new MemoryStream();
		Stream second;
		long pos = 0;
		public DoubleStream(Stream data)
		{
			second = data;
		}

		public override bool CanRead
		{
			get
			{return true;}
		}

		public override bool CanSeek
		{
			get
			{return true;}
		}

		public override bool CanWrite
		{
			get
			{return true;}
		}

		public override void Close()
		{
			mem.Close();
			second.Close();
		}

		public override void Flush()
		{
			mem.Flush();
		}

		public override long Length
		{
			get
			{
				return mem.Length + second.Length;
			}
		}

		public override long Position
		{
			get{return pos;}
			set
			{
				pos = value;
				if(pos < mem.Length)
					mem.Position = pos;
				else
					second.Position = pos - mem.Length;
			}
		}

		public override int Read(byte[] buffer, int offset, int count)
		{
			int rc = 0;
			int rc2 = 0;
			if(pos <= mem.Length)
				rc = mem.Read(buffer,0,count);
			if(rc < count)
				rc2 = second.Read(buffer,rc,count-rc);
			pos += rc+rc2;
			return rc+rc2;
		}

		public override long Seek(long offset, SeekOrigin origin)
		{
			switch(origin)
			{
				case SeekOrigin.Begin:
					return Position = offset;
				case SeekOrigin.Current:
					return Position = Position + offset;
				case SeekOrigin.End:
					return Position = Length + offset;
			}
			return -1;
		}

		public override void SetLength(long value)
		{
			mem.SetLength(value -second.Length);
		}

		public override void Write(byte[] buffer, int offset, int count)
		{
			mem.Write(buffer,offset,count);
		}

	}

	public class LimitedSizeStream: Stream
	{
		protected Stream baseStream;
		protected long size;
		protected long start;

		public LimitedSizeStream(long size,Stream baseS)
		{
			baseStream = baseS;
			this.size = size;
			start = baseS.Position;
		}

		public override bool CanRead
		{
			get
			{return true;}
		}

		public override bool CanSeek
		{
			get
			{return true;}
		}

		public override bool CanWrite
		{
			get
			{return false;}
		}

		public override void Close()
		{
			baseStream.Close();
		}

		public override void Flush()
		{
			baseStream.Flush();
		}

		public override long Length
		{
			get
			{
				return Math.Min(size,baseStream.Length-start);
			}
		}

		public override long Position
		{
			get{return baseStream.Position - start;}
			set
			{
				baseStream.Position = value + start;
			}
		}

		public override int Read(byte[] buffer, int offset, int count)
		{
			if(count + baseStream.Position > start + size)
				count = (int)(start + size - baseStream.Position);
			if (count <= 0) return -1;
			return baseStream.Read(buffer,offset,count);
		}

		public override long Seek(long offset, SeekOrigin origin)
		{
			if(origin == SeekOrigin.End)
			{
				offset-=(baseStream.Length -size);
			}
			return baseStream.Seek(offset,origin);
		}

		public override void SetLength(long value)
		{
			size = value;
		}

		public override void Write(byte[] buffer, int offset, int count)
		{
			throw new NotSupportedException("Write not supported by LimitedSizeStream");
		}

	}
}
