//#define TRACEMUTEX
using System;
using System.IO;
using System.Threading;
using System.Collections;
using System.Diagnostics;

namespace Bertaccini.Utils
{
	public class Mutex2
	{
		protected ArrayList WaitingThreads = new ArrayList();
		protected int _value;
		protected int Initial;
		protected string name = "unnamed";
		protected Mutex syncRoot = new Mutex();

		#region Accessors
		public int Value
		{
			get{return _value;}
		}

		public int WaitingCount
		{
			get{return WaitingThreads.Count;}
		}

		public bool Avaiable
		{
			get{return _value > 0;}
		}
		public string Name
		{
			get{return name;}
		}
		#endregion

		#region Constructors
		public Mutex2():this(1){}

		public Mutex2(int intialValue)
		{
			_value = Initial = intialValue;
		}

		public Mutex2(string name):this(1,name){}

		public Mutex2(int intialValue,string name):this(intialValue)
		{
			this.name = name;
		}
		#endregion

		#region Mutex Control

		public virtual void Wait()
		{
			Thread t = Thread.CurrentThread;
#if TRACEMUTEX
			Trace.WriteLine(t.Name + " requested " + name + "** "+_value.ToString());
#endif
			syncRoot.WaitOne();
			while(_value == 0)
			{
#if TRACEMUTEX
				Trace.WriteLine(t.Name + " locked on " + name+ "** Wating:"+WaitingThreads.Count+1);
#endif
				WaitingThreads.Add(t);
				syncRoot.ReleaseMutex();
				t.Suspend();
				syncRoot.WaitOne();
#if TRACEMUTEX
				Trace.WriteLine(t.Name + " UNlocked on " + name+ "** "+_value.ToString());
#endif
				WaitingThreads.Remove(t);
			}
			_value--;
			syncRoot.ReleaseMutex();
		}

		public void Signal()
		{
#if TRACEMUTEX
			Trace.WriteLine(Thread.CurrentThread.Name + " signaled " + name+ "** "+_value.ToString());
#endif
			syncRoot.WaitOne();
			_value++;
			if(WaitingThreads.Count > 0)
			{
				Thread t = (Thread)WaitingThreads[0];
				while(t.ThreadState != System.Threading.ThreadState.Suspended)
				{
#if TRACEMUTEX
					Trace.WriteLine("Thread not suspended, waiting");
#endif
					Thread.Sleep(10);
				}
				t.Resume();
			}
			syncRoot.ReleaseMutex();
		}
		#endregion
	}
}
