using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Bertaccini.Utils
{
	/// <summary>
	/// Summary description for InputBox.
	/// </summary>
	public class InputBox : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Label lblText;
		private System.Windows.Forms.TextBox txtInput;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public InputBox()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		public string Input
		{
			get{return txtInput.Text;}
			set{txtInput.Text = value;}
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.lblText = new System.Windows.Forms.Label();
			this.txtInput = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(288, 64);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "OK";
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(376, 64);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "Cancel";
			// 
			// lblText
			// 
			this.lblText.BackColor = System.Drawing.SystemColors.Control;
			this.lblText.Location = new System.Drawing.Point(8, 8);
			this.lblText.Name = "lblText";
			this.lblText.Size = new System.Drawing.Size(448, 23);
			this.lblText.TabIndex = 2;
			this.lblText.Text = "Type input below";
			// 
			// txtInput
			// 
			this.txtInput.Location = new System.Drawing.Point(8, 40);
			this.txtInput.Name = "txtInput";
			this.txtInput.Size = new System.Drawing.Size(448, 20);
			this.txtInput.TabIndex = 0;
			this.txtInput.Text = "";
			// 
			// InputBox
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(466, 93);
			this.Controls.Add(this.txtInput);
			this.Controls.Add(this.lblText);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "InputBox";
			this.Text = "InputBox";
			this.ResumeLayout(false);

		}
		#endregion

		#region Static activation of the form
		public static DialogResult Show(string formTitle,string text, bool showCancel,IWin32Window owner,out string input)
		{
			InputBox bx = new InputBox();
			bx.btnCancel.Visible = showCancel;
			if(formTitle != null)
				bx.Text = formTitle;
			if(text != null)
				bx.lblText.Text = text;
			DialogResult res;
			if(owner != null)
				res = bx.ShowDialog(owner);
			else
				res = bx.ShowDialog();
			input = bx.Input;
			return res;
		}

		public static DialogResult Show(string formTitle,string text, bool showCancel,out string input)
		{
			return Show(formTitle,text,showCancel,null,out input);
		}

		public static DialogResult Show(string formTitle,string text,out string input)
		{
			return Show(formTitle,text,true,out input);
		}

		public static DialogResult Show(string text,out string input)
		{
			return Show(null,text,out input);
		}
		#endregion
	}
}
