VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CIPAddress"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Oggetto rappresenta un indirizzo IP versione 4 del tipo xxx.yyy.zzz.jjj
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Il valore viene impostato all'indirizzo di LoopBack 127.0.0.1 in fase di costruzione.
'* </DIV>
' *********************************************************************
Option Explicit

'* Vettore contenente le parti costituenti un indirizzo IP
Private mIPParts(1 To 4) As Byte

'* Indica che qualcuno ha modificato l'indirizzo ip
Public Event OnChangeIpAddress()

'* Restituisce la componente da 1 a 4 dell'indirizzo IP
Public Property Get Part(Index As Integer) As Byte
    If Index > 0 And Index <= 4 Then
        Part = mIPParts(Index)
    End If
End Property

'* Restituisce la componente da 1 a 4 dell'indirizzo IP
Private Property Let Part(Index As Integer, newValue As Byte)
    If Index > 0 And Index <= 4 Then
        mIPParts(Index) = newValue
    End If
End Property

'* Setta come indirizzo IP, l'indirizzo di loopback <I>LocalHost 127.0.0.1</I>
Private Sub setLoopBackIp()
    mIPParts(1) = 127
    mIPParts(2) = 0
    mIPParts(3) = 0
    mIPParts(4) = 1
End Sub

'* Rappresentazione in forma di stringa dell'indirizzo IP
Public Function toString() As String
    toString = CStr(mIPParts(1)) & "." & _
                CStr(mIPParts(2)) & "." & _
                CStr(mIPParts(3)) & "." & _
                CStr(mIPParts(4))
End Function

'* Ricrea l'indirizzo IP dalla sua rappresentazione in forma di stringa
Public Sub fromString(Value As String)
Dim splitted()  As String
Dim i           As Byte
    If Not IsIP(Value) Then Err.Raise vbObjectError + 101, Me, Value & " non allowed as IP Address!"
    splitted = Split(Value, ".")
    'Settaggi
    For i = 1 To 4
        mIPParts(i) = CByte(splitted(i - 1))
    Next i
    RaiseEvent OnChangeIpAddress
End Sub

'* Verifica se la stringa rappresenta un indirizzo IP
Public Function IsIP(Value As String) As Boolean
Dim splitted()  As String
Dim i           As Byte
    splitted = Split(Value, ".")
    If UBound(splitted) <> 3 Then Exit Function
    'Controlli
    For i = 0 To 3
        If Not IsNumeric(splitted(i)) Then Exit Function
        If Int(splitted(i)) < 0 Or Int(splitted(i)) > 256 Then Exit Function
    Next i
    IsIP = True
End Function

'* Ottiene il nome dell'host che ha questo IP
Public Function getHostName() As String
Dim lngRetValue As Long
Dim udtHostent  As HOSTENT      'structure to hold the host info - returned by the _
                                 getsockname and getpeername Winsock API functions

    lngRetValue = gethostbyaddr(AsInetAddress(), 4&, AF_INET)
    If lngRetValue <> 0 Then
        CopyMemory udtHostent, ByVal lngRetValue, Len(udtHostent)
        getHostName = StringFromPointer(udtHostent.hName)
    Else
        getHostName = toString()
    End If
End Function

'* Restituisce l'indirizzo IP memorizzato sotto forma di InternetAddress
Public Property Get AsInetAddress() As Long
    AsInetAddress = inet_addr(toString())
End Property

'* Restituisce l'indirizzo IP memorizzato sotto forma di InternetAddress
Friend Property Let FromInetAddress(IP As Long)
    Call fromString(StringFromPointer(inet_ntoa(IP)))
End Property

'* Indica se l'oggetto passato contiene le stesse informazioni dell'oggetto corrente
Public Function Equals(OtherIP As CIPAddress) As Boolean
    Equals = (OtherIP.toString() = Me.toString())
End Function

Private Sub Class_Initialize()
    setLoopBackIp
End Sub
