VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CVector"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Gestisce un vettore di oggetti
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Semplice collezione ordinata di oggetti.
'* </DIV>
' *********************************************************************
Option Explicit

'* Oggetti contenuti nel vettore.
Private mElementData() As Object

'* Oggetto all'indice indicato
Public Property Get Element(Index As Long) As Object
    If Index > 0 And Index <= Size Then
        Set Element = mElementData(Index)
    End If
End Property

'* Oggetto all'indice indicato
Public Property Set Element(Index As Long, Obj As Object)
    If Index > 0 And Index <= Size Then
        Set mElementData(Index) = Obj
    End If
End Property

'* Permette di aggiungere un oggetto al vettore
Public Sub AddElement(Obj As Object)
    Call AddElementAt(Size + 1, Obj)
End Sub

'* Permette di aggiungere un oggetto al vettore in posizione indicata
Public Sub AddElementAt(Index As Long, Obj As Object)
Dim i           As Long
    If (Index <= Size + 1) And (Index > 0) Then
        ReDim Preserve mElementData(0 To Size + 1)
        'Sposto in alto cancellando l'oggetto da eliminare
        For i = Size To Index + 1 Step -1
            Set mElementData(i) = mElementData(i - 1)
        Next i
        Set mElementData(Index) = Obj
    End If
End Sub

'* Permette di rimuovere l'oggetto indicato se presente
Public Sub RemoveElement(Obj As Object)
    Call RemoveElementAt(IndexOf(Obj))
End Sub

'* Permette di rimuovere l'oggetto alla posizione indicata
Public Sub RemoveElementAt(Index As Long)
Dim i           As Long
    If (Index >= Size) And (Index > 0) Then
        'Sposto in basso cancellando l'oggetto da eliminare
        For i = Index To Size - 1
            Set mElementData(i) = mElementData(i + 1)
        Next i
        ReDim Preserve mElementData(0 To Size - 1)
    End If
End Sub

'* Indica il numero di oggetti contenuti nel vettore
Public Property Get Size() As Long
    Size = UBound(mElementData)
End Property

'* Indica la posizione dell'oggetto corrente nel vettore. Restituisce 0 se l'oggetto  assente
Public Function IndexOf(Obj As Object) As Long
Dim i   As Long
    IndexOf = 0
    For i = 1 To Size
        If mElementData(i) Is Obj Then
            IndexOf = i
            Exit For
        End If
    Next i
End Function

'* Rimuove tutti gli oggetti dal vettore
Public Sub Clear()
    ReDim mElementData(0 To 0)
End Sub

'* Indica se l'oggetto  contenuto nel vettore.
Public Function Contains(Obj As Object) As Boolean
    Contains = (IndexOf(Obj) > 0)
End Function

Private Sub Class_Initialize()
    Call Clear
End Sub

Private Sub Class_Terminate()
    Erase mElementData
End Sub
