VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CRemoteHost"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Rappresentazione di un EndPoint di comunicazione tramite Socket.
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Un end-point viene rappresentato mediante indirizzo Ip e numero di Porta.
'*  Il valore dell'IP viene impostato all'indirizzo di LoopBack 127.0.0.1 in fase di costruzione.
'*  La porta viene lasciata a 0 in fase di costruzione (utile per socket client che non specificano _
    la porta sulla quale eseguire il bind)
'* </DIV>
' *********************************************************************
Option Explicit

'* Porta dell'host remoto
Public Port       As Long
'* Indirizzo IP dell'host remoto
Private WithEvents mIp    As CIPAddress
Attribute mIp.VB_VarHelpID = -1
'* Indica che qualcuno ha modificato l'indirizzo ip
Public Event OnChangeIpAddress()

'* Converte il numero di porta memorizzato nel formato necessario per le specifiche di rete
Public Property Get PortToNetworkSpecs() As Integer
    PortToNetworkSpecs = htons(UnsignedToInteger(Port))
End Property

'* Converte il numero di porta memorizzato nel formato necessario per le specifiche di rete
Public Property Let PortFromNetworkSpecs(newValue As Integer)
    Port = IntegerToUnsigned(ntohs(newValue))
End Property

'* Indirizzo IP dell'host
Public Property Get IP() As CIPAddress
    Set IP = mIp
End Property

'* Indirizzo IP dell'host
Public Property Set IP(newValue As CIPAddress)
    Set mIp = newValue
    RaiseEvent OnChangeIpAddress
End Property

'* Restituisce la rappresentazione in forma di stringa di un host remoto
Function toString() As String
    toString = IP.toString() & ":" & CStr(Port)
End Function

'* Restituisce la rappresentazione in forma di stringa di un host remoto
Sub fromString(Value As String)
Dim splitted()  As String
    splitted = Split(Value, ":")
    If UBound(splitted) <> 1 Then Err.Raise vbObjectError + 101, Me, Value & " non allowed for CEnvelope string description!"
    If Not IsNumeric(splitted(1)) Then Err.Raise vbObjectError + 101, Me, Value & " non allowed for CEnvelope string description!"
    IP.fromString splitted(0)
    Port = CLng(splitted(1))
End Sub

'* Indica se l'oggetto passato contiene le stesse informazioni dell'oggetto corrente
Public Function Equals(OtherRemoteHost As CRemoteHost) As Boolean
    Equals = (OtherRemoteHost.Port = Me.Port) And Me.IP.Equals(OtherRemoteHost.IP)
End Function

Private Sub Class_Initialize()
    Set IP = New CIPAddress
End Sub

Private Sub mIP_OnChangeIpAddress()
    RaiseEvent OnChangeIpAddress
End Sub
