VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SMomUtilities"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Modulo di utilit. Contiene funzioni utili senza stato.
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Modulo di utilit. Le funzioni contenute in questa classe sono senza stato e sono _
    accessibili dall'esterno della libreria in maniera diretta senza istanziare l'oggetto.
'* </DIV>
' *********************************************************************
Option Explicit

'* Codici di errori lanciati dal servizio SMom
Public Enum SMomExceptionsCodes
    UnKnownSMomException = 10600
    ReceiverNotFoundException = 10601
    DispatcherNotFoundException = 10602
    MsgManagerNotFoundException = 10603
    
    TimeOutExpiredException = 10700
    MethodNotFoundException = 10701
    VarTypeUnKnownException = 10702
    InvalidTraceRouteDataException = 10703
    TooManyArgumentsForCallByName = 10704
    RemoteException = 10705
    UnKnownRemoteException = 10706
End Enum

'* Restituisce una stringa contenente un identificativo univoco che indica l'istante corrente
Public Function getTimeStamp() As String
    getTimeStamp = Format(Now, "YYYYMMDD_HHNNSS_" & CStr(Timer))
End Function

'* Restituisce una stringa che dovrebbe comporre un identificaore univoco
Function getUniqueIdentifier() As String
    getUniqueIdentifier = getTimeStamp() & "_" & CStr(Timer) & "_" & CStr(Rnd)
End Function

'* Crea una Envelope in stile funzionale
Public Function CreateEnvelope(Sender As ISender, Receiver As IReceiver, Message As String) As CEnvelope
Dim Env As New CEnvelope
    With Env
        Set .Sender = Sender
        Set .Receiver = Receiver
        .Message = Message
    End With
    Set CreateEnvelope = Env
End Function

'* Crea una Envelope in stile funzionale
Public Function CreateStrEnvelope(Sender As ISender, Receiver As String, Message As String) As CEnvelope
Dim Env As New CEnvelope
    With Env
        Set .Sender = Sender
        Call .SetReceiverByObjectID(Receiver)
        .Message = Message
    End With
    Set CreateStrEnvelope = Env
End Function


'* Permette di generare una eccezione con un commento standard
'* E' possibile aggiungere una descrizione aggiuntiva mediante il parametro MsgErrore
Public Function GetStandardSMomExceptionDescription(Error As SMomExceptionsCodes) As String
    Select Case Error
        Case ReceiverNotFoundException
            GetStandardSMomExceptionDescription = "Receiver not Found!"
        Case DispatcherNotFoundException
            GetStandardSMomExceptionDescription = "Dispatcher is not set!"
        Case MsgManagerNotFoundException
            GetStandardSMomExceptionDescription = "Manager could'nt be found!"
        Case TimeOutExpiredException
            GetStandardSMomExceptionDescription = "TimeOut for Remote Invocation has expired!"
        Case MethodNotFoundException
            GetStandardSMomExceptionDescription = "Method not Found in Servant!"
        Case InvalidTraceRouteDataException
            GetStandardSMomExceptionDescription = "TraceRoute data are not available or are incomplete!"
        Case TooManyArgumentsForCallByName
            GetStandardSMomExceptionDescription = "CDynamicSkeleton can handle functions whit less then 11 args!"
        Case RemoteException
            GetStandardSMomExceptionDescription = "Remote Object generated Exception!"
        Case UnKnownRemoteException
            GetStandardSMomExceptionDescription = "Remote Object generated Exception without description!"
        Case Else
            GetStandardSMomExceptionDescription = "Unknown Exception!"
    End Select
End Function

'* Restituisce un oggetto CValue passando un valore Variant fra quelli ammessi e gestiti dal Middleware ovvero:
'* <OL> _
    <LI>'TODO</LI> _
   </OL>
Public Function CreateCValue(Value As Variant) As CValue
    Select Case VarType(Value)
        Case vbBoolean, vbByte, vbCurrency, vbDate, vbDouble, vbNull, vbSingle
            'TODO
        Case vbLong
            Dim LongResultValue As New CInt32Value
            LongResultValue.setValue CLng(Value)
            Set CreateCValue = LongResultValue
        Case vbString
            Dim StringResultValue As New CStringValue
            StringResultValue.setValue CStr(Value)
            Set CreateCValue = StringResultValue
        Case Else
            RaiseSMomException VarTypeUnKnownException, , "Vb Data type " & TypeName(Value) & " not allowed in function SMom.CreateCValue()"
    End Select
End Function

'* Permette di generare una eccezione con un commento standard
'* E' possibile aggiungere una descrizione aggiuntiva mediante il parametro MsgErrore
Public Sub RaiseSMomException(Error As SMomExceptionsCodes, Optional Source As String = "SMom.UnknownSource!", Optional MsgErrore As String = vbNullString, Optional HelpFile, Optional HelpContext)
    Err.Raise vbObjectError + Error, Source, _
        IIf(MsgErrore <> vbNullString, MsgErrore & vbCrLf, vbNullString) & Utilities.GetStandardSMomExceptionDescription(Error), HelpFile, HelpContext
End Sub


