VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CFunctionResult"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Oggetto Rappresentante il risultato di una funzione
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Lo Sckeleton che riceve la richiesta di esecuzione di una funzione deve restituire _
al chiamante un oggetto di questo tipo.
'*  Il valore restituito deve essere di tipo previsto dalla (firma della) funzione.
'*  In caso di errore  necessario indicarlo tramite la propriet <B>ResultIsValid</B>
'* </DIV>
' *********************************************************************
Option Explicit

'* Valore restituito dalla funzione
Public FunctionResult As CValue
'* Indica se il risultato  corretto.
'* In caso contrario pu essere restituita una stringa di errore
Private mblnResultIsValid  As Boolean
'* Identificativo della procedura/funzione chiamata che ha causato questo risultato
Private mstrInstanceID   As String
'* Nome della procedura remota che ha causato il risultato
Private mstrName        As String

'* Carattere delimitatore utilizzato
Private Const CharDelimiter As String = ":"

'* Accesso alla propriet InstanceID dell'istanza
Public Property Get InstanceID() As String
    InstanceID = mstrInstanceID
End Property

'* Accesso alla propriet InstanceID dell'istanza
Public Property Let InstanceID(newValue As String)
    mstrInstanceID = newValue
End Property

'* Accesso alla propriet IsValid dell'istanza
Public Property Get IsValid() As Boolean
    IsValid = (mblnResultIsValid And Not (FunctionResult Is Nothing))
End Property

'* Accesso alla propriet IsValid dell'istanza
Public Property Let IsValid(newValue As Boolean)
    mblnResultIsValid = newValue
End Property

'* Accesso alla propriet Name dell'istanza
Public Property Let FunctionName(newValue As String)
    mstrName = newValue
End Property

'* Accesso alla propriet Name dell'istanza
Public Property Get FunctionName() As String
    FunctionName = mstrName
End Property

'* Rappresentazione del risultato per essere inviato.
'* Il messaggio ha la seguente rappresentazione
'* <InstanceIDLen><Separator><NameLen><Separator> _
    <InstanceID><Name>[<Param1Len>]
Public Function toMsgEnvelope() As String
Dim Message As String
Dim i       As Long
    'Header, Nome e InstanceID
    Message = CStr(Len(InstanceID)) & CharDelimiter & CStr(Len(FunctionName)) & CharDelimiter & _
              InstanceID & FunctionName
    'Risultato Valido
    Message = Message & IIf(IsValid, "1", "0")
    'Valore risultato
    If Not FunctionResult Is Nothing Then
        With FunctionResult
            Message = Message & .getType() & CharDelimiter & _
                                Len(.getActualValueToString()) & CharDelimiter & _
                                .getActualValueToString()
        End With
    End If
    'Restituisco il messaggio
    toMsgEnvelope = Message
End Function

'* Tenta di ricostruire la procedura dalla sua rappresentazione in forma di stringa _
contenuta nella busta.
'* Restituisce False in caso di errore nella costruzione
Public Function fromEnvelope(Env As CEnvelope) As Boolean
Dim Parti() As String
Dim i       As Long
Dim headerLenght    As Long
Dim numeroParametri As Long
Dim Risultato       As String
Dim currentParam    As CValue

    'Header, Nome e InstanceID
    Parti = Split(Env.Message, CharDelimiter)
    If UBound(Parti) < 2 Then Exit Function
    If Not (IsNumeric(Parti(0)) And IsNumeric(Parti(1))) Then Exit Function
    headerLenght = Len(Parti(0)) + Len(Parti(1)) + Len(CharDelimiter) * 2
    
    Me.InstanceID = Mid(Env.Message, headerLenght + 1, CLng(Parti(0)))
    Me.FunctionName = Mid(Env.Message, headerLenght + 1 + CLng(Parti(0)), CLng(Parti(1)))
    Me.IsValid = (Mid(Env.Message, headerLenght + 1 + CLng(Parti(0)) + CLng(Parti(1)), 1) = "1")
    
    'Valore risultato
    Risultato = Right(Env.Message, Len(Env.Message) - headerLenght - CLng(Parti(0)) - CLng(Parti(1)) - 1)
    If Len(Risultato) > 0 Then
        Parti = Split(Risultato, CharDelimiter, 3)
        If Not IsNumeric(Parti(1)) Then Exit Function
        headerLenght = Len(Parti(0)) + Len(Parti(1)) + Len(CharDelimiter) * 2
        Select Case Parti(0)
            Case "String"
                Set currentParam = New CStringValue
            Case "Int32"
                Set currentParam = New CInt32Value
            Case Else   'Tipo di parametro sconosciuto!!!
                Exit Function
        End Select
        'Setto il valore del parametro
        If Not currentParam.setActualValueFromString(Mid(Risultato, headerLenght + 1, CLng(Parti(1)))) Then Exit Function
        'Aggiungo il parametro
        Set Me.FunctionResult = currentParam
    End If
    fromEnvelope = True
End Function


