VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDynamicSkeleton"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Skeleton di base con chiamate dinamiche funzionante per una qualsiasi classe Servant
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Questo skeleton pu essere utilizzato per ogni oggetto in quanto contiene chiamate _
    dinamiche grazie alla <B>CallByName</B>.
'*  <B>A causa della limitatezza della CallByName,  possibile chiamare funzioni o procedure con _
    un massimo di 10 argomenti.</B>
'*  Creare una istanza della classe e associarvi il Servant attribuendo eventualmente un _
    ObjectID idoneo per l'applicazione.
'*  Associare la classe ad un Dispatcher in modo che riceva le richieste da parte dello Stub _
    corrispondente.
'* </DIV>
' *********************************************************************
Option Explicit

Implements IReceiver    'Necessario
Implements ISender      'Necessario per le funzioni

'* Classe reale che implementa le funzionalit fruibili dall'esterno
Private mServant     As Object
'* Variabile contenente il valore della propriet omonima
Private mstrObjectID As String

'* Restituisce l'identificativo univoco all'interno di questa applicazione dell'oggetto
Public Property Get SkeletonID() As String
    SkeletonID = mstrObjectID
End Property

'* Restituisce l'identificativo univoco all'interno di questa applicazione dell'oggetto
Public Property Let SkeletonID(Value As String)
    mstrObjectID = Value
End Property

'* Oggetto Servant che esegue le operazioni
Public Property Get Servant() As Object
    Set Servant = mServant
End Property

'* Oggetto Servant che esegue le operazioni
Public Property Set Servant(Value As Object)
    Set mServant = Value
End Property

Private Function IReceiver_getObjectID() As String
    IReceiver_getObjectID = SkeletonID
End Function

Private Function ISender_getObjectID() As String
    ISender_getObjectID = SkeletonID
End Function

Private Sub Class_Initialize()
    mstrObjectID = "CDynamicSkeleton|" & Utilities.getUniqueIdentifier()
End Sub

'* Gestisce il messaggio in arrivo rimbalzando la richiesta alla classe Servant
Private Sub IReceiver_msgArrived(Env As SMom.CEnvelope)
Dim Procedure       As New CProcedure
Dim i               As Long
Dim Risultato       As Variant
Dim FunctionResult  As CFunctionResult
Dim ResultValue     As CValue

    'Ricreo la procedura e la mando all'oggetto
    If Procedure.fromEnvelope(Env) Then
        'Chiamo la procedura per nome
        On Error GoTo CallByNameError
        'NOTA: NON POSSO PASSARE ALLA CallByName un VETTORE! DEVO PREVEDERE PER FORZA
        'N CHIAMATE DIVERSE A SECONDA DEL NUMERO DI PARAMETRI! (CHE SCHIFO!)
        Select Case Procedure.GetParamsCount()
        Case 0
            Risultato = CallByName(Servant, Procedure.Name, VbMethod)
        Case 1
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant())
        Case 2
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant())
        Case 3
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant())
        Case 4
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant())
        Case 5
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant(), Procedure.GetParam(5).toVariant())
        Case 6
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant(), Procedure.GetParam(5).toVariant(), Procedure.GetParam(6).toVariant())
        Case 7
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant(), Procedure.GetParam(5).toVariant(), Procedure.GetParam(6).toVariant(), Procedure.GetParam(7).toVariant())
        Case 8
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant(), Procedure.GetParam(5).toVariant(), Procedure.GetParam(6).toVariant(), Procedure.GetParam(7).toVariant(), Procedure.GetParam(8).toVariant())
        Case 9
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant(), Procedure.GetParam(5).toVariant(), Procedure.GetParam(6).toVariant(), Procedure.GetParam(7).toVariant(), Procedure.GetParam(8).toVariant(), Procedure.GetParam(9).toVariant())
        Case 10
            Risultato = CallByName(Servant, Procedure.Name, VbMethod, Procedure.GetParam(1).toVariant(), Procedure.GetParam(2).toVariant(), Procedure.GetParam(3).toVariant(), Procedure.GetParam(4).toVariant(), Procedure.GetParam(5).toVariant(), Procedure.GetParam(6).toVariant(), Procedure.GetParam(7).toVariant(), Procedure.GetParam(8).toVariant(), Procedure.GetParam(9).toVariant(), Procedure.GetParam(10).toVariant())
        Case Else
            On Error Resume Next
            Call Env.Replay( _
                Procedure.getResponseMessage(False, Utilities.CreateCValue(Procedure.toString() & vbCrLf & _
                            Utilities.GetStandardSMomExceptionDescription(TooManyArgumentsForCallByName))).toMsgEnvelope(), _
                Me)
            Exit Sub
        End Select
        
        'Se ho un risultato lo restituisco al chiamante
        'Se viene restituito Empty significa che era probabilmente una Sub
        If Not IsEmpty(Risultato) Then
            On Error Resume Next
            Call Env.Replay( _
                            Procedure.getResponseMessage(True, Utilities.CreateCValue(Risultato)).toMsgEnvelope(), _
                            Me)
        End If
    End If
Exit Sub
CallByNameError:
Dim StrErrorMessage As String
    Select Case Err.Number
        'TODO gestire eventuali errori gestibili
        Case Else
            StrErrorMessage = "UnknownError calling " & Procedure.toString() & " in SMom.CDynamicSkeleton." & vbCrLf & Err.Description
    End Select
    On Error Resume Next
    Call Env.Replay( _
        Procedure.getResponseMessage(False, Utilities.CreateCValue(StrErrorMessage)).toMsgEnvelope(), _
        Me)
End Sub

