VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "IMsgManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Interfaccia di un Manager che consente di inviare e ricevere messaggi
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Un Manager consente di interfacciarsi con altri Manager per poter scambiare messaggi a basso livello. _
    Per poter inviare un messaggio  necessario usare il metodo <I>Send</I>, mentre alla ricezione _
    di un messaggio, il Manager si incaricher di passare al Dispatcher collegato il messaggio che _
    sar recapitato al ricevente.
'*  Oggetti che implementano questa interfaccia devono contenere i <EN>meccanismi</EN> di spedizione e di ricezione di messaggi. _
    Le <EN>politiche</EN> per l'invio e la ricezione, al contrario, vanno implementate _
nei Dispatcher.
'*  Il Manager dovrebbe funzionare in modo sequenziale e sincrono, facendo rimanere in attesa il cliente sia durante _
una ricezione, sia durante una spedizione.
'*  Se all'arrivo di un messaggio non  ancora stato collegato un Dispatcher, il messaggio verr scartato.
'* </DIV>
' *********************************************************************
Option Explicit

'* Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
Public Property Get Dispatcher() As IDispatcher
End Property

'* Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
Public Property Set Dispatcher(dsptchr As IDispatcher)
End Property

'* Indirizzo logico del manager. Identifica il manager specificandolo in maniera univoca
Public Function getAddress() As String
End Function

'* Funzione che permette di inviare un messaggio ad un Manager di messaggi destinatario
'* Restituisce False se l'invio non va a buon fine. Le implementazioni di questa interfaccia _
indicheranno i motivi specifici per cui  possibile che si verifichi un errore (esempio: Manager _
destinazione sconosciuto)
Public Function Send(Env As CEnvelope, MngAddress As String) As Boolean
End Function
