VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CLocalManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Manager utilizzabile all'interno di una singola applicazione per inviare messaggi ad oggetti locali.
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Questo semplice <I>MsgManager</I> suppone che tutti i messaggi da inviare vengano spediti a un Manager _
locale (anche il manager stesso).
'*  Se il messaggio  indirizzato allo stesso Manager, notifica il Dispatcher collegato che _
    provveder ad inoltrare i messaggi agli oggetti locali destinatari; se, al contrario, il destinatario _
     un altro manager locale, esegue una <I>Send</I> dello stesso messaggio al destinatario.
'* </DIV>
' *********************************************************************
Option Explicit
Implements IMsgManager

'* Variabile contenente il valore della propriet omonima dell'oggetto
Private mDispatcher     As IDispatcher
'* Variabile contenente il valore della propriet omonima dell'oggetto
Private mManagers       As CVector
'* Variabile contenente il valore della propriet omonima dell'oggetto
Private mAddress        As String

'* Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
Public Property Get Dispatcher() As IDispatcher
    Set Dispatcher = mDispatcher
End Property

'* Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
Public Property Set Dispatcher(dsptchr As IDispatcher)
    Set mDispatcher = dsptchr
End Property

'* Indirizzo logico del manager. Identifica il manager specificandolo in maniera univoca
'* L'indirizzo viene generato automaticamente alla creazione dell'oggetto.
Public Function getAddress() As String
    getAddress = mAddress
End Function

'* Restituisce False se il manager non  nell'elenco dei manager registrati.
'* Se il manager destinazione  vuoto o  l'oggetto stesso, restituisce False se il Dispatcher non  stato specificato.
Public Function Send(Env As CEnvelope, MngAddress As String) As Boolean
Dim Index   As Long
Dim Manager As CLocalManager
    Send = False
    'Informazioni di dispatching
    If Env.TraceRoute Is Nothing Then Set Env.TraceRoute = New CEnvelopeTrace
    Env.TraceRoute.RemoteMsgManagerAddress = Me.getAddress()
    'Controllo se sono io
    If (MngAddress = vbNullString) Or (MngAddress = getAddress()) Then
        Send = SendToYou(Env)
    Else
        'Cerco fra altri managers registrati
        For Index = 1 To mManagers.Size
            Set Manager = mManagers.Element(Index)
            If Manager.getAddress() = MngAddress Then
                Send = Manager.SendToYou(Env)
            End If
        Next Index
    End If
End Function

'* Funzione chiamata dal CLocalManager di origine
'* La duplicazione della Send  necessaria per distinguere fra MsgManager di destinazione e di origine.
Friend Function SendToYou(Env As CEnvelope) As Boolean
    If Not Dispatcher Is Nothing Then
        'Informazioni di dispatching
        If Env.TraceRoute Is Nothing Then Set Env.TraceRoute = New CEnvelopeTrace
        Set Env.TraceRoute.LocalMsgManager = Me
        SendToYou = Dispatcher.msgArrived(Env)
    End If
End Function

'* Indica il numero di manager conosciuti.
Public Function getKnownManagerNumber() As Long
    getKnownManagerNumber = mManagers.Size
End Function

'* Funzione che permette di registrare un ulteriore Manager locale per la notifica di messaggi.
'* Se il manager  gi registrato non verr aggiunto ma la funzione restituir comunque True.
Public Function Register(OtherManager As CLocalManager) As Boolean
    Call mManagers.AddElement(OtherManager)
    Register = True
End Function

'* Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
'* Se il manager non risulta registrato la funzione restituir comunque True.
Public Function UnRegister(OtherManager As CLocalManager) As Boolean
    Call mManagers.RemoveElement(OtherManager)
    UnRegister = True
End Function

'* Consente di sapere se un Manager  registrato. Restituisce 0 se il manager non  registrato, un numero maggiore di 0 in caso contrario
Public Function IsRegistered(OtherManager As CLocalManager) As Long
    IsRegistered = mManagers.IndexOf(OtherManager)
End Function

Private Sub Class_Initialize()
    mAddress = "LocalManager|" & Utilities.getUniqueIdentifier()
    Set mManagers = New CVector
End Sub

Private Property Set IMsgManager_Dispatcher(RHS As IDispatcher)
    Set Dispatcher = RHS
End Property

Private Property Get IMsgManager_Dispatcher() As IDispatcher
    Set IMsgManager_Dispatcher = Dispatcher
End Property

Private Function IMsgManager_getAddress() As String
    IMsgManager_getAddress = getAddress
End Function

Private Function IMsgManager_Send(Env As CEnvelope, MngAddress As String) As Boolean
    IMsgManager_Send = Send(Env, MngAddress)
End Function
