VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "IDispatcher"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Interfaccia di un Dispatcher di messaggi
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Un Dispatcher consente di decidere le <EN>politiche</EN> per l'invio e la ricezione di messaggi _
    (es: lavorare in maniera sincrona/asincrona, decidere quante code di entrate/uscita usare, ecc...).
'*  L'oggetto utilizza un <I>MsgManager</I> per inviare fisicamente i messaggi utilizzando quindi i _
    <EN>meccanismi</EN> di spedizione implementati da tale oggetto.
'*  Se alla richiesta di invio di un messaggio non  ancora stato collegato un MsgManager, il messaggio verr scartato.
'* </DIV>
' *********************************************************************
Option Explicit

'* Identificativo dell'oggetto che si occuper di spedire i messaggi ai destinatari
Public Property Get MsgManager() As IMsgManager
End Property

'* Identificativo dell'oggetto che si occuper di spedire i messaggi ai destinatari
Public Property Set MsgManager(dsptchr As IMsgManager)
End Property

'* Funzione che permette ad un possibile destinatario di messaggi, di registrarsi presso il dispatcher
Public Function Register(Receiver As IReceiver) As Boolean
End Function

'* Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
Public Function UnRegister(Receiver As IReceiver) As Boolean
End Function

'* Funzione di CallBack chiamata dal Manager che richiede al dispatcher di inviare il messaggio ad uno dei riceventi registratisi
Public Function msgArrived(Env As CEnvelope) As Boolean
End Function

'* Funzione che permette di inviare un messaggio ad un Manager di messaggi destinatario
'* <B>Per poter inviare un messaggio  necessario aver legato il dispatcher ad un MsgManager!</B>
'* Restituisce False se l'invio non va a buon fine. Le implementazioni di questa interfaccia _
indicheranno i motivi specifici per cui  possibile che si verifichi un errore (esempio: Manager _
destinazione sconosciuto)
Public Function Send(Env As CEnvelope, MngAddress As String) As Boolean
End Function
