VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CEnvelope"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' *********************************************************************
'* CLASS Rappresentazione di una busta (lettera) tramite cui si inviano messaggi con il middleware
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  La classe rappresenta una busta a livello applicativo. A basso livello il messaggio _
    verr incapsulato in maniera differente a seconda del Canale usato per la spedizione.
'*  In fase di ricezione il messaggio viene ricreato prima di consegnarlo al ricevente e _
    alla busta vengono aggiunte le informazioni di tracciabilit per consentire un <B>Replay</B> _
    del messaggio in maniera quanto pi automatica possibile.
'* </DIV>
' *********************************************************************
Option Explicit

'* Attributo contenente il valore della propriet omonima dell'oggetto
Private mSender         As ISender
'* Attributo contenente il valore della propriet omonima dell'oggetto
Private mReceiver       As IReceiver
'* Attributo contenente il valore della propriet omonima dell'oggetto
Private mstrMessage     As String
'* Attributo contenente il valore della propriet omonima dell'oggetto
Private mTraceRoute     As CEnvelopeTrace

'* Carattere delimitatore utilizzato
Private Const CharDelimiter As String = ":"

'* Identificativo del mittente del messaggio
Public Property Get Sender() As ISender
    Set Sender = mSender
End Property

'* Identificativo del mittente del messaggio
Public Property Set Sender(sndr As ISender)
    Set mSender = sndr
End Property

'* Informazioni per la tracciabilit del messaggio
'* Questo attributo viene valorizzato dal Manager e dal Dispatcher di ricezione.
Public Property Get TraceRoute() As CEnvelopeTrace
    Set TraceRoute = mTraceRoute
End Property

'* Informazioni per la tracciabilit del messaggio
'* Questo attributo viene valorizzato dal Manager e dal Dispatcher di ricezione.
Public Property Set TraceRoute(sndr As CEnvelopeTrace)
    Set mTraceRoute = sndr
End Property

'* Identificativo del destinatario del messaggio
Public Property Get Receiver() As IReceiver
    Set Receiver = mReceiver
End Property

'* Identificativo del destinatario del messaggio
Public Property Set Receiver(rcvr As IReceiver)
    Set mReceiver = rcvr
End Property

'* Setta come ricevente un semplice segnaposto con l'ID indicato
Public Sub SetReceiverByObjectID(ObjID As String)
    Dim NewReceiver As New CEmptySender
    NewReceiver.ObjectID = ObjID
    Set Receiver = NewReceiver
End Sub

'* Rappresentazione in forma di stringa del messaggio da inviare
Public Property Get Message() As String
    Message = mstrMessage
End Property

'* Rappresentazione in forma di stringa del messaggio da inviare
Public Property Let Message(msg As String)
    mstrMessage = msg
End Property

'* Permette di recuperare una rappresentazione in forma di stringa dell'oggetto
'* Formato:
'* <SenderObjIDLen>|<ReceiverObjIDLen>|<MessageLen|<SenderObjID><ReceiverObjID><Message>
Public Function toString() As String
    toString = CStr(Len(Sender.getObjectID())) & CharDelimiter & _
                CStr(Len(Receiver.getObjectID())) & CharDelimiter & _
                CStr(Len(Message)) & CharDelimiter & _
                Sender.getObjectID() & _
                Receiver.getObjectID() & _
                Message
End Function

'* Permette di creare un oggetto CEnvelope ottenendo i dati dalla rappresentazione in forma di stringa.
Public Function fromString(ByVal StrEnvelope As String) As Boolean
Dim Env()   As String
Dim tmpSender   As New CEmptySender
Dim tmpReceiver As New CEmptySender
Dim headerLenght    As Integer

    Env = Split(StrEnvelope, CharDelimiter)
    If UBound(Env) < 2 Then Exit Function
    If Not (IsNumeric(Env(0)) And IsNumeric(Env(1)) And IsNumeric(Env(2))) Then Exit Function
    headerLenght = 3 + Len(Env(0)) + Len(Env(1)) + Len(Env(2))
    tmpSender.ObjectID = Mid(StrEnvelope, headerLenght + 1, Val(Env(0)))
    tmpReceiver.ObjectID = Mid(StrEnvelope, headerLenght + CLng(Env(0)) + 1, Val(Env(1)))
    Message = Mid(StrEnvelope, headerLenght + CLng(Env(0)) + CLng(Env(1)) + 1, Val(Env(2)))
    Set Sender = tmpSender
    Set Receiver = tmpReceiver
    fromString = True
End Function

'* Grazie alle funzionalit di tracciabilit  possibile rispondere al messaggio _
semplicemente indicando il messaggio di ritorno
'* La funzione restituisce il risultato della Send applicata al MsgManager locale che ha _
ricevuto il messaggio.
'* Non  ovviamente garantito che il MsgManager di origine conosca il Receiver.
Public Function Replay(Message As String, Optional ByVal MsgSender As ISender = Nothing) As Boolean
Dim snd     As CEmptySender
    'Se non  specificato il Sender ne creo uno fittizio
    If MsgSender Is Nothing Then
        Set snd = New CEmptySender
        snd.ObjectID = Receiver.getObjectID()
        Set MsgSender = snd
    End If
    'Spedisco il messaggio al MsgManager locale con indirizzo il MsgManager remoto
    Replay = TraceRoute.LocalMsgManager.Send( _
            Utilities.CreateStrEnvelope(MsgSender, Me.Sender.getObjectID(), Message), _
            TraceRoute.RemoteMsgManagerAddress)

End Function

