VERSION 5.00
Begin VB.Form frmBattagliaNavaleFromVb 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Battaglia Navale. Da Visual Basic a Java... by Giorgio Bernardi"
   ClientHeight    =   1455
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7260
   BeginProperty Font 
      Name            =   "Comic Sans MS"
      Size            =   14.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmBattagliaNavaleFromVb.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1455
   ScaleWidth      =   7260
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame frParametri 
      Caption         =   "Parametri di configurazione"
      Height          =   1455
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   7215
      Begin VB.CommandButton cmdConnetti 
         Caption         =   "Connetti..."
         Height          =   975
         Left            =   5520
         TabIndex        =   9
         Top             =   360
         Width           =   1575
      End
      Begin VB.TextBox txtIPAddress 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "Comic Sans MS"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   465
         Left            =   3840
         MaxLength       =   15
         TabIndex        =   7
         Text            =   "127.0.0.1"
         Top             =   840
         Width           =   1575
      End
      Begin VB.TextBox txtServerPort 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "Comic Sans MS"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   465
         Left            =   3840
         MaxLength       =   5
         TabIndex        =   6
         Top             =   360
         Width           =   1575
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "IP Server di ascolto: "
         BeginProperty Font 
            Name            =   "Comic Sans MS"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   960
         Width           =   3735
      End
      Begin VB.Label Label1 
         Alignment       =   1  'Right Justify
         Caption         =   "Porta di ascolto del Server: "
         BeginProperty Font 
            Name            =   "Comic Sans MS"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   5
         Top             =   480
         Width           =   3735
      End
   End
   Begin VB.Frame frToolBar 
      Caption         =   "Tool Bar Battaglia Navale"
      Height          =   1455
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   7215
      Begin VB.CommandButton Command2 
         Caption         =   "Termina Gioco"
         Height          =   855
         Left            =   4800
         TabIndex        =   3
         Top             =   480
         Width           =   2295
      End
      Begin VB.CommandButton cmdIstruzioni 
         Caption         =   "Leggi Istruzioni"
         Height          =   855
         Left            =   2520
         TabIndex        =   2
         Top             =   480
         Width           =   2175
      End
      Begin VB.CommandButton cmdNuovaPartita 
         Caption         =   "Nuova Partita"
         Height          =   855
         Left            =   120
         TabIndex        =   1
         Top             =   480
         Width           =   2295
      End
   End
End
Attribute VB_Name = "frmBattagliaNavaleFromVb"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' *********************************************************************
'* CLASS Client semplice per l'applicazione di BattagliaNavale implementata in Java.
'* <BR/>Autore: <B>Giorgio Bernardi</B>
'* E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
'* Web: <A HREF="http://Giorgio_Bernardi.tripod.com/">http://Giorgio_Bernardi.tripod.com</A>
'* Data  : Settembre 2004
'* <DIV CLASS="ClassDescription">
'*  Questo progetto mostra come sia possibile utilizzare il progetto <B>Simple Message _
    Oriented Middleware</B> fra una applicazione Visual Basic e Java utilizzando semplici _
    messaggi.
'* </DIV>
' *********************************************************************

Option Explicit
Implements SMom.ISender

Private Const mDEFAULTSERVERPORT    As Integer = 6450

'* Riferimento la Manager utilizzato
Private Manager             As New SMom.CTCPManager

'* Nome generato automaticamente per il sender
Private mstrSenderObjectID  As String

'* Identificativo del VbWrapper
Private Const mWBWRAPPERID  As String = "VbWrapper"

Private Sub cmdConnetti_Click()
    If Manager Is Nothing Then Set Manager = New SMom.CTCPManager
    If Manager.send(CreateHelloMsg(), JavaServerAddress) Then
        Call Gioca
    Else
        MsgBox "Non riesco a spedire il messaggio al server!"
    End If
End Sub

Private Sub Gioca()
    frToolBar.Visible = True
    frParametri.Visible = False
End Sub

Private Sub cmdIstruzioni_Click()
    Call Manager.send(CreateReadInstructions(), JavaServerAddress)
End Sub

Private Sub cmdNuovaPartita_Click()
    Call Manager.send(CreateNewGameMsg(), JavaServerAddress)
End Sub

Private Sub Command2_Click()
    Call Manager.send(CreateByeMsg(), JavaServerAddress)
End Sub

Private Sub Form_Initialize()
    mstrSenderObjectID = "VbBattagliaNavale" & SMom.getUniqueIdentifier()
End Sub

Private Sub Form_Load()
    txtServerPort.Text = CStr(mDEFAULTSERVERPORT)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    If Not Manager Is Nothing Then
        Call Manager.send(CreateByeMsg(), JavaServerAddress)
        Call Manager.send(CreateByeByeMsg(), JavaServerAddress)
        Set Manager = Nothing
    End If
    End
End Sub

Private Property Get JavaServerAddress() As String
    JavaServerAddress = RemoteIp.toString()
End Property

'* Porta selezionata dall'utente
Private Property Get RemotePort() As Long
On Error GoTo ErrorCatch
    If IsNumeric(txtServerPort.Text) Then
        RemotePort = CLng(txtServerPort.Text)
        Exit Property
    End If
ErrorCatch: RemotePort = mDEFAULTSERVERPORT
End Property

'* Porta selezionata dall'utente
Private Property Get RemoteIp() As SMom.CRemoteHost
Dim Remote  As New CRemoteHost
    With Remote
        'IP
        If .IP.IsIP(txtIPAddress.Text) Then
            Call .IP.fromString(txtIPAddress.Text)
        Else
            Call .IP.fromString("127.0.0.1")
        End If
        'Porta
        .Port = RemotePort
    End With
    Set RemoteIp = Remote
End Property

'* Indica il server personale che gestisce il gioco
Private Property Get PersonalServerOID() As String
    PersonalServerOID = mstrSenderObjectID & "VbWrapper"
End Property

Private Function ISender_getObjectID() As String
    ISender_getObjectID = mstrSenderObjectID
End Function

Private Sub txtServerPort_Validate(Cancel As Boolean)
    If Trim(txtServerPort.Text) <> "" Then
        If Not IsNumeric(txtServerPort.Text) Then
            MsgBox "Inserire un numero di porta intero!"
            Cancel = True
        End If
    End If
End Sub

'* Crea un messaggio di tipo Hello
Private Function CreateHelloMsg() As SMom.CEnvelope
    Set CreateHelloMsg = SMom.CreateStrEnvelope(Me, mWBWRAPPERID, "HELLO")
End Function

'* Crea un messaggio di tipo Bye per il server personale
Private Function CreateByeMsg() As SMom.CEnvelope
    Set CreateByeMsg = SMom.CreateStrEnvelope(Me, PersonalServerOID, "BYE")
End Function

'* Crea un messaggio di tipo Bye per il server
Private Function CreateByeByeMsg() As SMom.CEnvelope
    Set CreateByeByeMsg = SMom.CreateStrEnvelope(Me, mWBWRAPPERID, "BYE")
End Function

'* Crea un messaggio di tipo New Game
Private Function CreateNewGameMsg() As SMom.CEnvelope
    Set CreateNewGameMsg = SMom.CreateStrEnvelope(Me, PersonalServerOID, "NEW_GAME")
End Function

'* Crea un messaggio di tipo Read Instructions
Private Function CreateReadInstructions() As SMom.CEnvelope
    Set CreateReadInstructions = SMom.CreateStrEnvelope(Me, PersonalServerOID, "SHOW_ISTRUCTIONS")
End Function
