package TestSMom;

import SMom.*;
import SMom.Dispatcher.*;
import SMom.MsgManager.*;
import SMom.ObjectOriented.*;

import java.awt.*;
import java.awt.event.*;

/**
 *Classe di test per il supporto ObjectOriented del sistema Simple Message Oriented Middleware.
 * <DIV CLASS="ClassDescription">
 *	Classe di test. Vedere metodo Main per i dettagli sull'esecuzione.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CTestOOSMom extends Frame implements ActionListener,WindowListener {
	private TextArea	t;
	private Button[]		CmdExecute;
	private TextField[]		TextInput;

	private SMom.MsgManager.IMsgManager MsgManager1;
	private SMom.MsgManager.IMsgManager MsgManager2;
	private ClsTestProcedures					ClsTest;
	private ClsTestProcedures					ClsStub;
	
	
	public static int MODO_LOCALE=0;
	public static int MODO_TCP_LOCALE=1;
	public static int MODO_REMOTO_SERVER=2;
	public static int MODO_REMOTO_CLIENT=3;
	
	/**
	 * Procedura di inizializzazione.
	 * Passare come parametro 0,1,2 o 3 per inizializzare l'ambiente.
	 * Valori
	 * <UL>
	 *	<LI>MODO_LOCALE=0</LI>
	 *	<LI>MODO_TCP_LOCALE=1</LI>
	 *	<LI>MODO_REMOTO_SERVER=2</LI>
	 *	<LI>MODO_REMOTO_CLIENT=3</LI>
	 * </UL>
	 */
	public static void main(String[] args) {
		int modo=0;
		if (args!=null)
			if (args.length>0)
				modo = Integer.parseInt(args[0]);
		//Esecuzione
		(new CTestOOSMom(modo)).show();
	}
	
	/**
	 * Costruttore della finestra grafica
	 */
	public CTestOOSMom(int SetupMode) {
		t = new TextArea(100,100);
		
		CmdExecute=new Button[7];
		CmdExecute[0] = new Button("hello()");
		CmdExecute[1] = new Button("ComputeSum()");
		CmdExecute[2] = new Button("ComputeDiff()");
		CmdExecute[3] = new Button("GetSum()");
		CmdExecute[4] = new Button("Concatena()");
		CmdExecute[5] = new Button("BigConcatena()");
		CmdExecute[6] = new Button("Divide()");
		
		Panel Bottoni = new Panel(new GridLayout(CmdExecute.length,1));
		for(int i=0;i<CmdExecute.length;i++){
			CmdExecute[i].addActionListener(this);
			Bottoni.add(CmdExecute[i]);
		}
		
		TextInput = new TextField[12];
		Panel Inputs = new Panel(new GridLayout(1,TextInput.length));
		for(int i=0; i<TextInput.length; i++){
			TextInput[i] = new TextField(String.valueOf(3*(11-i)));
			Inputs.add(TextInput[i]);
		}
			
		
		InitServer(SetupMode);
		
		setLayout(new java.awt.BorderLayout());
		t.setVisible(true);
		this.add(Bottoni,BorderLayout.WEST);
		this.add(Inputs,BorderLayout.SOUTH);
		this.add(t,BorderLayout.CENTER);
		this.setVisible(true);
		this.setSize(800,600);
		this.addWindowListener(this);
		
	}


	/***
	* Procedura di setup per testare l'interoperabilit con visual basic
	*/
	private void InitServer(int SetupMode) {
		CSinchronusAndSequentialDispatcher Dispatcher
		 		= new CSinchronusAndSequentialDispatcher();
		String MsgManagerAddress=null;
		
		if (SetupMode==this.MODO_LOCALE){
			//Preparazione manager locale
			CLocalManager MsgManager = new CLocalManager();
	   		MsgManager.setDispatcher(Dispatcher);
	    	Dispatcher.setMsgManager(MsgManager);
	    }else{
	  		try{
	  			//Client
				CTcpManager MsgManager1 = new CTcpManager(4501);
				MsgManager1.setDispatcher(Dispatcher);
				if ((SetupMode==this.MODO_TCP_LOCALE) ||
					(SetupMode==this.MODO_REMOTO_CLIENT))
						MsgManager1.StartListenforMessages();
				//Server
				CTcpManager MsgManager2 = new CTcpManager(5501);
				MsgManager2.setDispatcher(Dispatcher);
				if ((SetupMode==this.MODO_TCP_LOCALE) ||
					(SetupMode==this.MODO_REMOTO_SERVER))
						MsgManager2.StartListenforMessages();
				
				Dispatcher.setMsgManager(MsgManager1);
				MsgManagerAddress = MsgManager2.getAddress();
				
	    	}catch(Exception e){
	    		System.out.println(e);
	    		System.exit(0);
	    	}
		}
    	//----------------	Preparazione	-----------------
    	ClsTest = new ClsTestProcedures(t);

	    //Utilizzo dello Skeleton Dinamico
		CDynamicSkeleton clsSckeleton = new CDynamicSkeleton();
    	clsSckeleton.setServant(ClsTest);
    	clsSckeleton.setSkeletonID("ClsTestProcedures_Sckeleton");

		//'Utilizzo di stub Dinamico
		ClsTestProcedures_DynamicStub clsMyStub = 
			new ClsTestProcedures_DynamicStub(t,new CDynamicStub(
													Dispatcher,
													MsgManagerAddress,
													"ClsTestProcedures_Sckeleton",
													"ClsTestProcedures_Stub"));
		Dispatcher.Register(clsMyStub.DynamicStub);
    
	    //'Comune
	    Dispatcher.Register(clsSckeleton);
	    this.ClsStub = clsMyStub;
	}
	
	private void Append(String value){
		t.append(value + "\r\n");
	}
	
	/**
	 *	Esecuzione della procedura di test
	 */
	public void actionPerformed(ActionEvent parm1) {
        if (parm1.getSource()==CmdExecute[0]){
            Append("Chiamata senza risultato a hello()");
            ClsStub.hello();
        }else if (parm1.getSource()==CmdExecute[1]){
            Append("Chiamata senza risultato a ComputeSum()");
            ClsStub.ComputeSum(Arg1(),Arg2());
        }else if (parm1.getSource()==CmdExecute[2]){
            Append("Risultato di ComputeDiff=" +
                ClsStub.ComputeDiff(Arg1(), Arg2()));
        }else if (parm1.getSource()==CmdExecute[3]){
            Append("Risultato di GetSum=" +
                ClsStub.GetSum(Arg1(), Arg2()));
        }else if (parm1.getSource()==CmdExecute[4])
            Append("Risultato di Concatena=" + 
            	ClsStub.Concatena(TextInput[0].getText(),
            							TextInput[1].getText(),
            							TextInput[2].getText()));
        else if (parm1.getSource()==CmdExecute[5])
            Append("Risultato di BigConcatena=" +
                ClsStub.BigConcatena(TextInput[0].getText(), TextInput[1].getText(), TextInput[2].getText(),
									TextInput[3].getText(), TextInput[4].getText(), TextInput[5].getText(),
									TextInput[6].getText(), TextInput[7].getText(), TextInput[8].getText(),
									TextInput[9].getText(), TextInput[10].getText(), TextInput[11].getText()));
        else if (parm1.getSource()==CmdExecute[6])
            Append("Risultato di Divide=" +
                ClsStub.Divide(Arg1(),Arg2()));
	}
	
	private int Arg1(){
		return Integer.parseInt(TextInput[0].getText());
	}
	
	private int Arg2(){
		return Integer.parseInt(TextInput[1].getText());
	}
	
	public void windowOpened(WindowEvent parm1) 
	{
		// TODO: Add your code here
	}

	public void windowClosing(WindowEvent parm1) 
	{
		setVisible(false);
		this.dispose();
		System.exit(0);

	}

	public void windowClosed(WindowEvent parm1) 
	{
		// TODO: Add your code here
	}

	public void windowIconified(WindowEvent parm1) 
	{
		// TODO: Add your code here
	}

	public void windowDeiconified(WindowEvent parm1) 
	{
		// TODO: Add your code here
	}

	public void windowActivated(WindowEvent parm1) 
	{
		// TODO: Add your code here
	}

	public void windowDeactivated(WindowEvent parm1) 
	{
		// TODO: Add your code here
	}
}

/**
 * Proxy che usa skeleton dinamico per la classe di test in Java.
 * <DIV CLASS="ClassDescription">
 *	La classe implementa l'interfaccia della classe genitore e rimbalza le chiamate allo
 *	skeleton dinamico.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
class ClsTestProcedures_DynamicStub extends ClsTestProcedures{
	public  SMom.ObjectOriented.CDynamicStub DynamicStub;
	public ClsTestProcedures_DynamicStub(TextArea te,SMom.ObjectOriented.CDynamicStub DynamicStub){
		super(te);
		this.DynamicStub = DynamicStub;
	}

	private void Append(String text){
		super.t.append(text + "\r\n");
	}
	
	/**
	 *	Funzione pubblica di test: procedura senza argomenti.
	 */
	public void hello(){
		try{
        	DynamicStub.CallRemoteFunction("hello", false, null);
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.hello(): Exception=>" + ex);
        }
	}
	
	/**
	 *	Funzione pubblica di test: permette di testare la gestione degli errori (0/0).
	 */
	public int Divide(int Arg1, int Arg2){
		java.util.Vector args = new java.util.Vector();
		args.add(new Integer(Arg1));
		args.add(new Integer(Arg2));
		try{
        	return ((SMom.ObjectOriented.Values.CInt32Value)
        		DynamicStub.CallRemoteFunction("Divide",true, args.elements())).getValue();
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.Divide: Exception=>" + ex);
        	return -1;
        }
	}

	/**
	 *	Funzione pubblica di test: procedura con argomenti interi ma senza risultato.
	 */
	public void ComputeSum(int Arg1, int Arg2){
		java.util.Vector args = new java.util.Vector();
		args.add(new Integer(Arg1));
		args.add(new Integer(Arg2));
		
		try{
        	DynamicStub.CallRemoteFunction("ComputeSum",false, args.elements());
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.ComputeSum: Exception=>" + ex);
        }
	}
	
	/**
	 *	Funzione pubblica di test: procedura con risultato anche negativo
	 */
	public int ComputeDiff(int Arg1, int Arg2){
		java.util.Vector args = new java.util.Vector();
		args.add(new Integer(Arg1));
		args.add(new Integer(Arg2));
		try{
        	return ((SMom.ObjectOriented.Values.CInt32Value)
        		DynamicStub.CallRemoteFunction("ComputeDiff",true, args.elements())).getValue();
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.ComputeDiff: Exception=>" + ex);
        	return -1;
        }
	}
	
	/**
	 *	Funzione pubblica di test: funzione con risultato intero.
	 */
	public int GetSum(int Arg1, int Arg2){
		java.util.Vector args = new java.util.Vector();
		args.add(new Integer(Arg1));
		args.add(new Integer(Arg2));
		try{
        	return ((SMom.ObjectOriented.Values.CInt32Value)
        		DynamicStub.CallRemoteFunction("GetSum",true, args.elements())).getValue();
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.GetSum: Exception=>" + ex);
        	return -1;
        }
	}
	
	/**
	 *	Funzione pubblica di test: funzione con parametri e risultati Stringa
	 */
	public String Concatena(String Str1, String Str2, String Str3){
		java.util.Vector args = new java.util.Vector();
		args.add(Str1);
		args.add(Str2);
		args.add(Str3);
		try{
        	return ((SMom.ObjectOriented.Values.CStringValue)
        		DynamicStub.CallRemoteFunction("Concatena",true, args.elements())).getValue();
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.Concatena: Exception=>" + ex);
        	return "Exception " + ex;
        }
	}
	
	/**
	 *	Funzione con troppi argomenti per essere chiamata con lo skeleton dinamico in Visual Basic.
	 */
	public String BigConcatena( String a, String b, String c,
								String d, String e, String f,
								String g, String h, String i,
								String l, String m, String n){
		java.util.Vector args = new java.util.Vector();
		args.add(a);
		args.add(b);
		args.add(c);
		args.add(d);
		args.add(e);
		args.add(f);
		args.add(g);
		args.add(h);
		args.add(i);
		args.add(l);
		args.add(m);
		args.add(n);
		try{
        	return ((SMom.ObjectOriented.Values.CStringValue)
        		DynamicStub.CallRemoteFunction("BigConcatena",true, args.elements())).getValue();
        }catch(SMom.Exceptions.CSMomException ex){
        	Append("ClsDynStub.BigConcatena: Exception=>" + ex);
        	return "Exception " + ex;
        }
	}
}
