package SMom.ObjectOriented.Values;


/**
 * Classe astratta che rappresenta un valore di una variabile semplice.
 * <DIV CLASS="ClassDescription">
 *  Implementare i metodi di questa classe per ogni tipo di dato (es: String, Integer, ecc...)
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public abstract class CValue{
	/**
	 * Restituisce la rappresentazione in forma di stringa del valore memorizzato
	 */
	public abstract String	getActualValueToString();
	
	/**
	 * Setta il valore memorizzato dalla rappresentazione in forma di stringa
	 */
	public abstract boolean setActualValueFromString(String newValue);

	/**
	 * Restituisce il nome del tipo di dato memorizzato
	 */
	public abstract String	getType();

	/**
	 * Restituisce la classe Java dell'oggetto esempio String o Integer, ecc...
	 */
	public abstract Class	getJavaClass();

	/**
	 * Restituisce la rappresentazione in un oggetto Java del valore contenuto.
	 */
	public abstract Object	toJavaObject();
	
	/**
	 * Crea una istanza della classe partendo da un oggetto del tipo giusto
	 */
	public static CValue Create(Object Value){
		return null;
	}
	
	/**
	 * Tenta di creare un CValue corretto recuperando il valore dall'oggetto indicato.
	 * Gli oggetti possibili sono quelli che mappano dei valori di base di Java, ovvero:
	 * <OL>
	 *	<LI>Integer</LI>
	 *	<LI>String</LI>
	 *	<LI>'TODO</LI>
	 * </OL>
	 */
	public static CValue CreateCValue(Object Value){
		if (Value.getClass().getName().equals("java.lang.String"))
			return CStringValue.Create(Value);
		else if (Value.getClass().getName().equals("java.lang.Integer"))
			return CInt32Value.Create(Value);
		
		//In caso di errore restituisco null
		System.err.println("CreateCValue ERROR! per " + Value);
		return null;
	}
}
