package SMom.ObjectOriented.Values;

/**
 * Oggetto che rappresenta un valore di tipo Stringa.
 * <DIV CLASS="ClassDescription">
 *  In fase di costruzione viene impostata la stringa vuota
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CStringValue extends CValue{

	/**
	 * Valore memorizzato
	 */
	private String mValue;
	
	/**
	 * Costruttore di default.
	 * Pone a "" il valore corrente
	 */
	public CStringValue(){
	    this("");
	}

	/**
	 * Costruttore mediante Stringa
	 */
	public CStringValue(String Value){
		setValue(Value);
	}

	/**
	 * Crea una istanza della classe partendo da un oggetto del tipo giusto
	 */
	public static CValue Create(Object Value){
		return new CStringValue((String)Value);
	}

	/**
	 * Restituisce la rappresentazione in un oggetto Java del valore contenuto.
	 */
	public Object	toJavaObject(){
		return new String(mValue);
	}
	
	/**
	 * Restituisce la rappresentazione in forma di stringa del valore memorizzato
	 */
	public String getActualValueToString(){
		return getValue();
	}
	
	/**
	 * Setta il valore memorizzato dalla rappresentazione in forma di stringa
	 */
	public boolean setActualValueFromString(String newValue){
		setValue(newValue);
		return true;
	}

	/**
	 * Restituisce il nome del tipo di dato memorizzato
	 */
	public String getType(){
		return "String";
	}
	
	/**
	 *	Accesso al valore memorizzato
	 */
	public String getValue(){
	    return mValue;
	}
	
	/**
	 * Accesso al valore memorizzato
	 */
	public void setValue(String newValue){
	    mValue = newValue;
	}

	/**
	 * Restituisce la classe Java dell'oggetto esempio String o Integer, ecc...
	 */
	public Class	getJavaClass(){
		return mValue.getClass();
	}
}
