package SMom.ObjectOriented.Values;


/**
 * Oggetto che rappresenta un valore di tipo Integer a 32 bit (int in Java).
 * <DIV CLASS="ClassDescription">
 *  Il valore viene impostato a 0 in fase di costruzione.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CInt32Value extends CValue{

	/**
	 * Valore memorizzato
	 */
	private int mValue;

	
	/**
	 * Costruttore di default.
	 * Pone a 0 il valore corrente
	 */
	public CInt32Value(){
	    this(0);
	}

	/**
	 * Costruttore di default.
	 * Pone a 0 il valore corrente
	 */
	public CInt32Value(int Value){
	    setValue(Value);
	}
	
	/**
	 * Crea una istanza della classe partendo da un oggetto del tipo giusto
	 */
	public static CValue Create(Object Value){
		return new CInt32Value(((Integer)Value).intValue());
	}

	/**
	 * Restituisce la rappresentazione in un oggetto Java del valore contenuto.
	 */
	public Object	toJavaObject(){
		return new Integer(mValue);
	}

	/**
	 * Restituisce la rappresentazione in forma di stringa del valore memorizzato
	 */
	public String getActualValueToString(){
		return String.valueOf(getValue());
	}
	
	/**
	 * Setta il valore memorizzato dalla rappresentazione in forma di stringa
	 */
	public boolean setActualValueFromString(String newValue){
		try{
			setValue(Integer.parseInt(newValue));
			return true;
		}catch(NumberFormatException c){
			return false;
		}
	}

	/**
	 * Restituisce il nome del tipo di dato memorizzato
	 */
	public String getType(){
		return "Int32";
	}
	
	/**
	 *	Accesso al valore memorizzato
	 */
	public int getValue(){
	    return mValue;
	}
	
	/**
	 * Accesso al valore memorizzato
	 */
	public void setValue(int newValue){
	    mValue = newValue;
	}


	/**
	 * Restituisce la classe Java dell'oggetto esempio String o Integer, ecc...
	 */
	public Class	getJavaClass(){
		return Integer.TYPE;
	}
}
