package SMom.ObjectOriented;
import SMom.*;
import SMom.ObjectOriented.Values.*;

/**
 * Oggetto Funzione utile per incapsulare chiamate a procedura remote.
 * <DIV CLASS="ClassDescription">
 *  Creare la procedura o funzione aggiungendo parametri e impostando il nome.
 *  In fase di costruzione viene automaticamente impostato un InstanceID di default (che si consiglia di non modificare).
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CProcedure {
	/**
	 * Nome della procedura remota da chiamare
	 */
	private String mstrName;
	
	/**
	 * Identificativo univoco di questa chiamata a procedura
	 */
	private String mstrInstanceID;
	
	/**
	 * Parametri in ingresso alla procedura remota
	 */
	private java.util.Vector mParams;
	
	/**
	 * Carattere delimitatore utilizzato
	 */
	protected static String CharDelimiter = ":";

	/**
	 * Costruisce una nuova procedura vuota
	 */
	public CProcedure(){
	    mstrInstanceID = "CProcedure|" + SMom.SMomUtilities.getUniqueIdentifier();
	    mParams = new java.util.Vector();
	}

	/**
	 * Costruisce una nuova procedura indicando gi il nome
	 */
	public CProcedure(String Name){
		this();
		setName(Name);
	}

	/**
	 * Costruisce una nuova procedura indicando gi il nome
	 */
	public CProcedure(CEnvelope Env) throws SMom.Exceptions.CCannotConvertEnvelopeToCProcedureException{
		this();
		if (!this.fromEnvelope(Env))
			throw new SMom.Exceptions.CCannotConvertEnvelopeToCProcedureException("SMom.CProcedure",Env.getMessage());
	}
	
	/**
	 * Permette di aggiungere un parametro alla procedura
	 */
	public void AddParam(CValue newParam){
		mParams.addElement(newParam);
	}
	
	/**
	 * Permette di recuperare il parametro all'indice indicato della procedura
	 * Restituisce <I>null</I> se all'indice non corrisponde alcun parametro
	 */
	public CValue GetParam(int Index){
		if ((GetParamsCount()>=Index) && (Index>0))
	    	return (CValue)(mParams.elementAt(Index-1));
	    else
	    	return null;
	}
	
	/**
	 * Indica il numero di parametri attualmente memorizzati per la procedura
	 */
	public int GetParamsCount(){
	    return mParams.size();
	}

	/**
	 * Restituisce un array di oggetti di tipo Class in Java avendo in ingresso
	 * una procedura.
	 * Se la procedura non ha argomenti restituisce null.
	 */
	public Class[] GetParamsClass(){
		if (GetParamsCount()>0){
			Class[] returnValue = new Class[GetParamsCount()];
			for(int i=1; i<=GetParamsCount(); i++)
				returnValue[i-1] = GetParam(i).getJavaClass();
			//Restituisco il vettore
			return returnValue;
		}else return null;
	}
	
	/**
	 * Restituisce un array degli oggetti parametri della procedura.
	 * Se la procedura non ha argomenti restituisce null.
	 */
	public Object[] GetParams(){
		if (GetParamsCount()>0){
			Object[] returnValue = new Object[GetParamsCount()];
			for(int i=1; i<=GetParamsCount(); i++){
				Object ret = GetParam(i).toJavaObject();
				returnValue[i-1] = ret;
			}
			//Restituisco il vettore
			return returnValue;
		}else return null;
	}
	
	/**
	 * Accesso alla propriet Name dell'istanza
	 */
	public void setName(String newValue){
	    mstrName = newValue;
	}
	
	/**
	 * Accesso alla propriet Name dell'istanza
	 */
	public String getName(){
	    return mstrName;
	}
	
	/**
	 * Accesso alla propriet InstanceID dell'istanza
	 */
	public String getInstanceID(){
	    return mstrInstanceID;
	}
	
	/**
	 * Accesso alla propriet InstanceID dell'istanza
	 */
	protected void setInstanceID(String newValue){
	    mstrInstanceID = newValue;
	}
	
	/**
	 * Rappresentazione semplice in forma di stringa della procedura
	 */
	public String toString(){
		String 	Result;

	    Result = getName() + "(";
	    for(int i = 1; i<GetParamsCount();i++){
	        if (i > 1) Result = Result + ",";
	        Result = Result + GetParam(i).getActualValueToString();
	 	}
	    return Result + ")";
	}
	
	/**
	 * Rappresentazione della procedura per essere inviata.
	 * Il messaggio ha la seguente rappresentazione
	 * <InstanceIDLen><Separator><NameLen><Separator><ParamsNumber><Separator>
	 *   <InstanceID><Name>[<Param1Len>]
	 */
	public CEnvelope toEnvelope(ISender Sender, String ReceiverObjID){
	    //Header, Nome e InstanceID
	    String Message =  String.valueOf(getInstanceID().length()) + CharDelimiter + 
			    		  String.valueOf(getName().length()) + CharDelimiter +
			              String.valueOf(GetParamsCount()) + CharDelimiter + getInstanceID() + getName();
	    //Parametri
	    for (int i = 1; i<= GetParamsCount();i++)
	        Message = Message + GetParam(i).getType() + CharDelimiter +
	        			String.valueOf(GetParam(i).getActualValueToString().length()) + CharDelimiter +
	                    GetParam(i).getActualValueToString();
		//Restituisco la Envelope con il messaggio selezionato
	    return new CEnvelope(Sender, ReceiverObjID, Message);
	}
	
	/**
	 * Tenta di ricostruire la procedura dalla sua rappresentazione in forma di stringa contenuta nella busta.
	 * Restituisce False in caso di errore nella costruzione.
	 */
	protected boolean fromEnvelope(CEnvelope Env){
	    //Header, Nome e InstanceID
	    String Parti[] = Env.getMessage().split(CharDelimiter,4);
	    int lenInstanceID = Integer.parseInt(Parti[0]);
	    int lenName			= Integer.parseInt(Parti[1]);
	    int numeroParametri	= Integer.parseInt(Parti[2]);
	    int headerLenght = Parti[0].length() + Parti[1].length() + Parti[2].length() + CharDelimiter.length() * 3;
	    
	    setInstanceID(Env.getMessage().substring(headerLenght, headerLenght + lenInstanceID));
	    setName(Env.getMessage().substring(headerLenght+lenInstanceID, headerLenght+lenInstanceID+lenName));
	    String parametri = Env.getMessage().substring(headerLenght+lenInstanceID+lenName);
	    
	    //Parametri
	    for(int i = 1;i<=numeroParametri;i++){
	    	CValue currentParam;
	    	if ((currentParam=parseFromString(parametri))!=null){
	    		//Aggiungo il parametro
	    		this.AddParam(currentParam);
	    		//Rimuovo dalla stringa la parte letta
	    		int paramLenght = 
	    			currentParam.getType().length()+
	    			currentParam.getActualValueToString().length()+
	    			String.valueOf(currentParam.getActualValueToString().length()).length()+2;
	    		if (i<numeroParametri) parametri = parametri.substring(paramLenght);
	    	}else return false;
	 	}
	    return true;
	}
	
	/**
	 * Esegue il parsing di un valore da una stringa
	 */
	protected static CValue parseFromString(String params){
		String Parti[] = params.split(CharDelimiter, 3);
        int headerLenght = Parti[0].length() + Parti[1].length() + CharDelimiter.length() * 2;
        CValue currentParam=null;
        if (Parti[0].equals("String"))
            currentParam = new CStringValue();
        else if (Parti[0].equals("Int32"))
            currentParam = new CInt32Value();
        else return null;   //Tipo di parametro sconosciuto!!!

        //Setto il valore del parametro
        if (!currentParam.setActualValueFromString(
        	params.substring(headerLenght, headerLenght+Integer.parseInt(Parti[1])))) return null;
        //Restituisco
        return currentParam;
        
	}
	
	/**
	 * Restituisce un oggetto CFunctionResult pronto per essere restituito al mittente
	 * E' necessario indicare se il risultato  valido e l'eventuale risultato della funzione
	 */
	public CFunctionResult getResponseMessage(boolean IsValid, CValue ResultValue){
	    return new CFunctionResult(this,IsValid,ResultValue);
	}
}