package SMom.ObjectOriented;
import SMom.ObjectOriented.Values.*;
import SMom.*;

/**
 * Oggetto Rappresentante il risultato di una funzione.
 * <DIV CLASS="ClassDescription">
 *  Lo Sckeleton che riceve la richiesta di esecuzione di una funzione deve restituire
 *  al chiamante un oggetto di questo tipo.
 *  Il valore restituito deve essere di tipo previsto dalla (firma della) funzione.
 *  In caso di errore  necessario indicarlo tramite la propriet <B>ResultIsValid</B>
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CFunctionResult {
	
	/**
	 * Valore restituito dalla funzione
	 */
	public CValue 	FunctionResult;
	
	/**
	 * Indica se il risultato  corretto.
	 * In caso contrario pu essere restituita una stringa di errore
	 */
	private boolean mblnResultIsValid;
	
	/**
	 * Identificativo della procedura/funzione chiamata che ha causato questo risultato
	 */
	private String mstrInstanceID;
	
	/**
	 * Nome della procedura remota che ha causato il risultato
	 */
	private String mstrName;
	
	/**
	 * Carattere delimitatore utilizzato.
	 */
	protected static String CharDelimiter = ":";
	
	/**
	 * Crea un nuovo risultato indicando la procedura ed il suo risultato
	 */
	public CFunctionResult(CProcedure f, boolean resultValid, CValue Result){
		setFunctionName(f.getName());
		setInstanceID(f.getInstanceID());
		setIsValid(resultValid);
		FunctionResult = Result;
	}
	
	/**
	 * Crea un nuovo oggetto dall messaggio contenuto nella busta
	 * Genera una eccezione in caso di impossibilit nel decifrare il messaggio.
	 */
	public CFunctionResult(SMom.CEnvelope Env) throws SMom.Exceptions.CCannotConvertEnvelopeToCFunctionResultException{
		if (!fromEnvelope(Env))
			throw new SMom.Exceptions.CCannotConvertEnvelopeToCFunctionResultException();
	}

	/**
	 * Accesso alla propriet InstanceID dell'istanza
	 */
	public String getInstanceID(){
	    return mstrInstanceID;
	}
	
	/**
	 * Accesso alla propriet InstanceID dell'istanza
	 */
	private void setInstanceID(String newValue){
	    mstrInstanceID = newValue;
	}
	
	/**
	 * Accesso alla propriet IsValid dell'istanza
	 */
	public boolean IsValid(){
	    return (mblnResultIsValid && !(FunctionResult==null));
	}
	
	/**
	 * Accesso alla propriet IsValid dell'istanza
	 */
	public void setIsValid(boolean newValue){
	    mblnResultIsValid = newValue;
	}
	
	/**
	 * Accesso alla propriet Name dell'istanza
	 */
	private void setFunctionName(String newValue){
	    mstrName = newValue;
	}
	
	/**
	 * Accesso alla propriet Name dell'istanza
	 */
	public String getFunctionName(){
	    return mstrName;
	}
	
	/**
	 * Rappresentazione del risultato per essere inviato.
	 * Il messaggio ha la seguente rappresentazione
	 * <InstanceIDLen><Separator><NameLen><Separator><InstanceID><Name>[<Param1Len>]
	 */
	public String toMsgEnvelope(){
		String Message;
		
	    //Header, Nome e InstanceID
	    Message = String.valueOf(getInstanceID().length()) + CharDelimiter + 
	    		  String.valueOf(getFunctionName().length()) + CharDelimiter +
	              getInstanceID() + getFunctionName();

	    //Risultato Valido
	    Message = Message + ((IsValid())?"1":"0");
	    
	    //Valore risultato
	    if (FunctionResult != null)
	        Message = Message + FunctionResult.getType() + CharDelimiter +
	                  String.valueOf(FunctionResult.getActualValueToString().length()) + CharDelimiter +
					  FunctionResult.getActualValueToString();

	    //Restituisco il messaggio
	    return Message;
	}
	
	/**
	 * Tenta di ricostruire la procedura dalla sua rappresentazione in forma di stringa
	 * contenuta nella busta.
	 * Restituisce False in caso di errore nella costruzione
	 */
	protected boolean fromEnvelope(CEnvelope Env){
		//Header, Nome e InstanceID
	    String Parti[] = Env.getMessage().split(CharDelimiter,3);
	    int lenInstanceID = Integer.parseInt(Parti[0]);
	    int lenFunctionName = Integer.parseInt(Parti[1]);
	    int headerLenght = Parti[0].length() + Parti[1].length() + CharDelimiter.length() * 2;
	    
	    setInstanceID(Env.getMessage().substring(headerLenght,headerLenght+lenInstanceID));
	    setFunctionName(Env.getMessage().substring(headerLenght+lenInstanceID,headerLenght+lenInstanceID+lenFunctionName));
	    //System.out.println("Valido?=" + Env.getMessage().charAt(headerLenght+lenInstanceID+lenFunctionName));
	    setIsValid(Env.getMessage().charAt(headerLenght+lenInstanceID+lenFunctionName)=='1');
	    
	    //Valore risultato
	    try{
	    	String Risultato = Env.getMessage().substring(headerLenght+lenInstanceID+lenFunctionName+1);
	    	if ((FunctionResult=CProcedure.parseFromString(Risultato))==null)
	    		return false;
	    }catch(IndexOutOfBoundsException ex){
	    	//Non c' risultato
	    }
	    return true;
	}
}
