package SMom.ObjectOriented;
import SMom.*;
import SMom.ObjectOriented.Values.CValue;
import SMom.MsgManager.IMsgManager;
import SMom.Dispatcher.IDispatcher;

/**
 * Stub di base con chiamate dinamiche funzionante per una qualsiasi classe.
 * <DIV CLASS="ClassDescription">
 *	'TODO
 *  Creare una istanza di questa classe e chiamare la funzione <B>CallRemoteFunction</B> specificando _
 *  i parametri necessari.
 *  E' possibile usare la classe indicando di non attendere il risultato delle funzioni e poi
recuperare il risultato stesso in modalit polling tramite le funzioni <B>IsResultArrived</B> e
<B>GetResult</B>.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CDynamicStub implements ISender, IReceiver{
	/**
	 * Dispatcher al quale inviare le richieste
	 */
	private IDispatcher mDispatcher;
	
	/**
	 * Indirizzo di ricezione del manager remoto
	 */
	private String mstrRemoteMsgManagerAddress;
	
	/**
	 * Indirizzo di ricezione dello Skeleton remoto
	 */
	private String mstrSkeletonObjectID;
	
	/**
	 * Collezione dei risultati delle funzioni attualmente disponibili
	 */
	private java.util.HashMap Risultati;

	/**
	 * Variabile contenente il valore della propriet omonima
	 */
	private String mstrObjectID;
	
	/**
	 * Secondi dopo il quale scatter il timeout se non giunge il risultato della chiamata a funzione
	 */
	private long mintTimeOutSeconds = DEFAULT_TIMEOUT_MILLI_SECONDS;
	
	/**
	 * TimeOut di default applicato all'inizializzazione della classe
	 */
	private static long DEFAULT_TIMEOUT_MILLI_SECONDS = 10000;
	
	/**
	 * Costruttore vuoto
	 */
	private CDynamicStub(){
	    Risultati = new java.util.HashMap();
	    setTimeOutMilliSeconds(DEFAULT_TIMEOUT_MILLI_SECONDS);
	}

	/**
	 * Costruttore dello stub dinamico.
	 * E' necessario impostare i vari argomenti.
	 */
	public CDynamicStub(IDispatcher Dispatcher, String RemoteMsgManagerAddress, String RemoteSkeletonObjectID){
	    this();
	    setDispatcher(Dispatcher);
	    setRemoteMsgManagerAddress(RemoteMsgManagerAddress);
	    setRemoteSkeletonID(RemoteSkeletonObjectID);
	}

	/**
	 * Costruttore dello stub dinamico.
	 * E' necessario impostare i vari argomenti.
	 */
	public CDynamicStub(IDispatcher Dispatcher, String RemoteMsgManagerAddress, String RemoteSkeletonObjectID, String StubID){
	    this(Dispatcher,RemoteMsgManagerAddress,RemoteSkeletonObjectID);
	    setStubID(StubID);
	}

	/**
	 * Restituisce l'identificativo univoco all'interno della applicazione remota dello skeleton di destinazione
	 */
	public String getRemoteSkeletonID(){
	    return mstrSkeletonObjectID;
	}
	
	/**
	 * Restituisce l'identificativo univoco all'interno della applicazione remota dello skeleton di destinazione
	 */
	public void setRemoteSkeletonID(String Value){
	    mstrSkeletonObjectID = Value;
	}
	
	/**
	 * Indirizzo di ricezione del manager remoto
	 */
	public String getRemoteMsgManagerAddress(){
	    return mstrRemoteMsgManagerAddress;
	}
	
	/**
	 * Indirizzo di ricezione del manager remoto
	 */
	public void setRemoteMsgManagerAddress(String Value){
	    mstrRemoteMsgManagerAddress = Value;
	}
	
	/**
	 * Milli secondi dopo il quale scatter il timeout se non giunge il risultato della chiamata a funzione
	 */
	public long getTimeOutMilliSeconds(){
	    return mintTimeOutSeconds;
	}
	
	/**
	 * Milli secondi dopo il quale scatter il timeout se non giunge il risultato della chiamata a funzione
	 */
	public void setTimeOutMilliSeconds(long Value){
	    mintTimeOutSeconds = Value;
	}
	
	/**
	 * Restituisce l'identificativo univoco all'interno di questa applicazione dell'oggetto
	 */
	public String getStubID(){
	    return mstrObjectID;
	}
	
	/**
	 * Restituisce l'identificativo univoco all'interno di questa applicazione dell'oggetto
	 */
	public void setStubID(String Value){
	    mstrObjectID = Value;
	}
	
	/**
	 * Verifica se  arrivato il risultato della richiesta
	 */
	public synchronized boolean IsResultArrived(String ProcedureInstanceID){
		return Risultati.containsKey(ProcedureInstanceID);
	}
	
	/**
	 * Restituisce il risultato della invocazione remota.
	 * Restituisce <I>null</I> se il risultato non  ancora giunto.
	 * Se il risultato  giunto lo restituisce e lo rimuove dalla collezione dei risultati arrivati
	 */
	public synchronized CFunctionResult GetResult(String ProcedureInstanceID){
	    if (IsResultArrived(ProcedureInstanceID)){
	        CFunctionResult Risultato = (CFunctionResult)Risultati.get(ProcedureInstanceID);
	        Risultati.remove(ProcedureInstanceID);
	        return Risultato;
	    }else return null;
	}
	
	/**
	 * Indica che  arrivato il risultato della richiesta
	 * Registra il risultato fra quelli disponibili
	 */
	private synchronized void ResultArrived(CFunctionResult Result){
	    Risultati.put(Result.getInstanceID(),Result);
	}
	
	/**
	 * Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public IDispatcher getDispatcher(){
	    return mDispatcher;
	}
	
	/**
	 * Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public void setDispatcher(IDispatcher dsptchr){
	    mDispatcher = dsptchr;
	}

	/**
	 * Funzione da chiamare per contattare lo Skeleton remoto.
	 * Impostare tutti i parametri della funzione da chiamare in modo da fornire una Enumerativo
	 * (passare null oppure un enumerativo vuoto se la funzione ha 0 argomenti).
	 * E' necessario indicare se attendere o meno il risultato della computazione remota. Questo 
	 *  importante sia nel caso in cui il metodo chiamato sia semplicemente una procedura senza ritorno,
	 * sia nel caso in cui non si desideri attendere il risultato ma semplicemente andarlo a pescare dopo
	 * eseguendo un polling sulla funzione IsResultAvailable.
	 * <B>Nota:</B> se non si desidera attendere il risultato, la funzione restituisce il nome univoco 
	 * della richiesta di procedura remota necessario per eseguire successivamente il polling del risultato.
	 */
	public Object CallRemoteFunction(String MethodName, boolean HoldOnForResult, java.util.Enumeration Arguments)
		throws SMom.Exceptions.CUnKnownSMomException,
				SMom.Exceptions.CUnKnownRemoteException,
				SMom.Exceptions.CRemoteException,
				SMom.Exceptions.CTimeOutExpiredException{
	    //Creazione delle informazioni sul metodo da chiamare
	    CProcedure Procedure = new CProcedure(MethodName);
	    //Aggiunta degli eventuali argomenti.
	    if (Arguments!=null)
		    while(Arguments.hasMoreElements())
		    	Procedure.AddParam(CValue.CreateCValue(Arguments.nextElement()));
/*
		System.out.println("RemoteMngAddr" + getRemoteMsgManagerAddress());
		System.out.println("Disp:" + getDispatcher());
		System.out.println("SkelID:" + getRemoteSkeletonID());
*/		
	    //Invio della richiesta
	    if (!getDispatcher().Send(Procedure.toEnvelope(this, getRemoteSkeletonID()), getRemoteMsgManagerAddress()))
	        throw new SMom.Exceptions.CUnKnownSMomException("SMom.CDynamicStub", "Dispatcher couldn't Send message");

	    //Se devo attendere il risultato...
	    if (HoldOnForResult)
	        return HoldResult(Procedure.getInstanceID(), getTimeOutMilliSeconds());
	    else    //'Restituisco l'InstanceID
	        return Procedure.getInstanceID();
	}
	
	/**
	 * Chiamare questa procedura se si desidera attendere il risultato della chiamata a funzione remota precedentemente effettuata.
	 */
	public CValue HoldResult(String ProcedureInstanceID, long TimeOutMilliSeconds)
		throws SMom.Exceptions.CUnKnownRemoteException,
				SMom.Exceptions.CRemoteException,
				SMom.Exceptions.CTimeOutExpiredException{
		/* In Java posso interrompere con un TimeOut massimo il thread che verr
		 * eventualmente svegliato all'arrivo del messaggio
		 */
	     
		//Attendo l'arrivo oppure il timout
		synchronized(this){
			//Tento per vedere se per caso  gi arrivato
			java.util.Date StartTime = new java.util.Date();
			
			while ((!IsResultArrived(ProcedureInstanceID)) &&
					(((new java.util.Date()).getTime()-StartTime.getTime())<=TimeOutMilliSeconds)
					)
				try{
					//Attendo ancora il tempo rimasto per aspettare
					long TimeToHold = TimeOutMilliSeconds-((new java.util.Date()).getTime()-StartTime.getTime());
					System.out.println("Attendo " + TimeToHold);
					this.wait(TimeToHold);
				}catch(Exception e){
					//Esco dal while a prescindere dal timeout
					break;
				}
		}
	     
		//Adesso verifico se  arrivato
		CFunctionResult Risultato = GetResult(ProcedureInstanceID);
		
		if (Risultato != null){
			if (Risultato.IsValid())   //Raccolgo il risultato e lo restituisco
				return Risultato.FunctionResult;
			else if (Risultato.FunctionResult != null)
				throw new SMom.Exceptions.CRemoteException("SMom.CDynamicStub", "RemoteException description:\r\n" +
				    Risultato.FunctionResult.getActualValueToString());
			else    //Errore non specificato!
				throw new SMom.Exceptions.CUnKnownRemoteException("SMom.CDynamicStub",null);
		}else	//TimeOut!
			throw new SMom.Exceptions.CTimeOutExpiredException("SMom.CDynamicStub", "Not found Result for Request:" + ProcedureInstanceID);
	}
	
	/**
	 * Restituisce lo StubID utiler per inviare e ricevere messaggi
	 */
	public String getObjectID(){
	    return getStubID();
	}
	
	public synchronized void msgArrived(SMom.CEnvelope Env){
	    //Sono arrivati dei risultati
	    //Aggiungo al vettore dei risultati e notifico tutti
	    try{
	    	CFunctionResult Risultato = new CFunctionResult(Env);
	        ResultArrived(Risultato);
	        notifyAll();
	 	}catch(SMom.Exceptions.CCannotConvertEnvelopeToCFunctionResultException e){
	 		//Che fare?!?!
	 		System.err.println(e.toString() + "\r\nin CDynamicStub.msgArrived");
	    }
	}
}
