package SMom.ObjectOriented;
import SMom.ObjectOriented.Values.*;
import SMom.*;

/**
 * Skeleton di base con chiamate dinamiche funzionante per una qualsiasi classe Servant.
 * <DIV CLASS="ClassDescription">
 *  Creare una istanza della classe e associarvi il Servant attribuendo eventualmente un 
 *  ObjectID idoneo per l'applicazione.
 *  Associare la classe ad un Dispatcher in modo che riceva le richieste da parte dello Stub
 *  corrispondente.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CDynamicSkeleton implements IReceiver, ISender{

	/**
	 * Classe reale che implementa le funzionalit fruibili dall'esterno
	 */
	private Object mServant;
	
	/**   
	 * Variabile contenente il valore della propriet omonima
	 */
	private String mstrObjectID;
	
	/**
	 * Restituisce l'identificativo univoco all'interno di questa applicazione dell'oggetto
	 */
	public String getSkeletonID(){
	    return mstrObjectID;
	}
	
	/**
	 * Restituisce l'identificativo univoco all'interno di questa applicazione dell'oggetto
	 */
	public void setSkeletonID(String Value){
	    mstrObjectID = Value;
	}
	
	/**
	 * Oggetto Servant che esegue le operazioni
	 */
	public Object getServant(){
	    return mServant;
	}
	
	/**
	 * Oggetto Servant che esegue le operazioni
	 */
	public void setServant(Object Value){
	    mServant = Value;
	}
	
	/**
	 * Id dell'oggetto.
	 * Funzione ereditata da ISender e IReceiver
	 */
	public String getObjectID(){
	    return getSkeletonID();
	}
	
	/**
	 * Costruttore di default.
	 * Setta l'ObjectID con un valore univoco.
	 */
	public CDynamicSkeleton(){
	    mstrObjectID = "CDynamicSkeleton|" + SMom.SMomUtilities.getUniqueIdentifier();
	}
	
	/**
	 * Gestisce il messaggio in arrivo rimbalzando la richiesta alla classe Servant
	 */
	public void msgArrived(SMom.CEnvelope Env){
		CProcedure Procedure;
		try{
			//Ricreo la procedura e la mando all'oggetto
	    	Procedure = new CProcedure(Env);
		}catch(SMom.Exceptions.CCannotConvertEnvelopeToCProcedureException ex){
			System.err.println(ex);
			return;
		}

		try{
			//Cerco il metodo per scoprire se ha ritorno o meno
			java.lang.reflect.Method
				metodo = getServant().getClass().getMethod(
							Procedure.getName(),
							Procedure.GetParamsClass());
			
			//Chiamo la procedura per nome
			Object Risultato = metodo.invoke(getServant(),Procedure.GetParams());
			
	        /*	Se ho un risultato lo restituisco al chiamante
	         *  Per verificarlo guardo se il tipo di ritorno del metodo  Void
	        */
	        if (!metodo.getReturnType().equals(java.lang.Void.TYPE))
	            Env.Replay(
                        (Procedure.getResponseMessage(true, CValue.CreateCValue(Risultato)).toMsgEnvelope()),
                        this);
		}catch(Exception ex){	//Tento di inviare al chiamate un messaggio di errore remoto
			System.err.println(ex);
            Env.Replay(
                    Procedure.getResponseMessage(false, CValue.CreateCValue(
                    (new SMom.Exceptions.CUnKnownRemoteException("SMom.CDynamicSkeleton",
                    	ex.toString())).toString())).toMsgEnvelope(),
                    this);
	    }
	}
}
