package SMom.MsgManager;
import SMom.Dispatcher.IDispatcher;
import SMom.CEnvelope;
/**
 * Interfaccia di un Manager che consente di inviare e ricevere messaggi.
 * <DIV CLASS="ClassDescription">
 *  Un Manager consente di interfacciarsi con altri Manager per poter scambiare messaggi a basso livello.
 *  Per poter inviare un messaggio  necessario usare il metodo <I>Send</I>, mentre alla ricezione
 *  di un messaggio, il Manager si incaricher di passare al Dispatcher collegato il messaggio che
 *  sar recapitato al ricevente.
 *  Oggetti che implementano questa interfaccia devono contenere i <EN>meccanismi</EN> di spedizione e 
 *	di ricezione di messaggi.
 *  Le <EN>politiche</EN> per l'invio e la ricezione, al contrario, vanno implementate nei Dispatcher.
 *  Il Manager dovrebbe funzionare in modo sequenziale e sincrono, facendo rimanere in attesa il 
 *	cliente sia durante una ricezione, sia durante una spedizione.
 *  Se all'arrivo di un messaggio non  ancora stato collegato un Dispatcher, il messaggio verr scartato.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public interface IMsgManager{

	/**
	 *Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public IDispatcher getDispatcher();
	
	/**
	 *Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public void setDispatcher(IDispatcher dsptchr);
	
	/**
	 * Indirizzo logico del manager. Identifica il manager specificandolo in maniera univoca
	 */
	public String getAddress();
	
	/**
	 * Indica il numero di manager conosciuti.
	 */
	public int getKnownManagerNumber();
	
	/**
	 * Funzione che permette di inviare un messaggio ad un Manager di messaggi destinatario
	 * Restituisce False se l'invio non va a buon fine. Le implementazioni di questa interfaccia 
	 * indicheranno i motivi specifici per cui  possibile che si verifichi un errore (esempio: Manager
	 * destinazione sconosciuto)
	 */
	public boolean Send(CEnvelope Env, String MngAddress);
}