package SMom.MsgManager;
import SMom.*;
import SMom.Dispatcher.IDispatcher;
/** Manager utilizzabile per connettere due applicazioni differenti via IP
 * <DIV CLASS="ClassDescription">
 *  Il manager funge da Server su porta TCP per ricevere i messaggi.
 *  Il manager sfrutta l'invio di messaggi TCP per spedire i messaggi.
 *  Il manager stabilisce un metodo per l'identificazione del Manager
 *  in modo che il nome <I>getAddress()</I> del Manager consenta di identificarlo in una rete di
 *  computer.
 *  Il manager stabilisce altres un formato di spedizione dei pacchetti TCP in modo che
 *  il destinatario possa comprenderlo ricreando a sua volta l'CEnvelope.
 *  Ad ogni richiesta di invio di un messaggio il manager legge la lista di connessioni aperte
 *  per verificare se conosce il destinatario, altrimenti crea una nuova connessione.
 *  Ad ogni richiesta di connessione dall'esterno, questa viene recuperata indicando che
 *  si conosce gi il mittente.
 *  <B>Importante:</B> le socket vanno chiuse esplicitamente altrimenti il GarbageCollector di
 *  Visual Basic le lascia aperte indefinitamente causando spiacevoli errori ed inconvenienti!
 *  Usare il metodo <B>Destroy</B> per pulire tutto.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public class CTcpManager extends Thread implements IMsgManager{
	
	/**
	 *Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private IDispatcher mDispatcher;
	
	/**
	 *Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private java.util.HashMap mManagers;
	
	/**
	 *Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private java.net.InetAddress mHostData;
	
	/**
	 * Numero della porta usata come server
	 */
	private int mServerPortNumber;

	/**
	 *Socket Server usata per accettare le connessioni dall'esterno
	 */
	private java.net.ServerSocket mServerSocket;
	
	/**
	 *	Porta di default per l'apertura di una nuova Socket server
	 */
	private static int mDEFAULT_PORT = 5230;
	
	private String mstrLastError;
	
	/**
	 *Indica che l'indirizzo del manager potrebbe essere cambiato
	 */
	//public Event OnAddressChange()
	
	/**
	 * Descrizione dell'ultimo errore
	 */
	public String getLastError(){
	    return mstrLastError;
	}
	
	/**
	 *Descrizione dell'ultimo errore
	 */
	private void setLastError(String newValue){
	    mstrLastError = newValue;
	}
	
	/**
	 * Gestisce l'errore
	 */
	private void GenerateError(String Description){
	    setLastError(Description);
	}
	
	/** 
	 * Gestisce l'errore
	 */
	private void GenerateErrorGenerico(String Procedure, Exception e){
	    GenerateError("Errore non previsto in " + Procedure + 
	    			SMom.SMomUtilities.vbCrLf + e.toString());
	}
	
	/**
	 *Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public IDispatcher getDispatcher(){
	    return mDispatcher;
	}
	
	/**
	 * Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public void setDispatcher(IDispatcher dsptchr){
	    mDispatcher = dsptchr;
	}
	
	/**
	 * Indirizzo logico del manager. Identifica il manager specificandolo in maniera univoca
	 * L'indirizzo viene generato automaticamente alla creazione dell'oggetto.
	 */
	public String getAddress(){
	    return mHostData.getHostAddress() + ':' + getPort();
	}
	
	/**
	 *Porta di ascolto per il manager
	 */
	public int getPort(){
	    return mServerPortNumber;
	}
	
	/**
	 *Indirizzo IP di ascolto per il manager
	 */
	public String getLocalIpAddress(){
		try{
	    	return java.net.InetAddress.getLocalHost().toString();
	    }catch(Exception e){
	    	GenerateError(e.toString());
	    	return "";
	    }
	}
	

	/** 
	 * La funzione ignora il MngAddress
	 * Restituisce False se il manager non  nell'elenco dei manager registrati.
	 * Se il manager destinazione  vuoto o  l'oggetto stesso, restituisce False se il Dispatcher non  stato specificato.
	 */
	public boolean Send(CEnvelope Env, String MngAddress){
    	//Informazioni di dispatching
    	if (Env.getTraceRoute()==null)
    		Env.setTraceRoute(new SMom.CEnvelopeTrace(getAddress()));
    	else
    		Env.getTraceRoute().setRemoteMsgManagerAddress(getAddress());
    	
	    //Controllo se sono io
	    if ((MngAddress.equalsIgnoreCase("")) || (MngAddress.equals(getAddress()))){
	        if (getDispatcher() != null)
	            return getDispatcher().msgArrived(Env);
		}else{
			CTcpManagerSlave PeerManagerSlave = FindPeerServer(MngAddress);
	        if (PeerManagerSlave ==null){
				String  RemoteMachine;
				int		RemotePort;
				RemoteMachine 	= MngAddress.substring(0,MngAddress.indexOf(':'));
				RemotePort		= Integer.parseInt(MngAddress.substring(MngAddress.indexOf(':')+1,MngAddress.length()));
				//'Ne creo uno tentando di connettermi al pari
	            PeerManagerSlave = new CTcpManagerSlave(this);
				if (PeerManagerSlave.StartConnecting(RemoteMachine,RemotePort)){
					//Eseguo in un thread separato.
					PeerManagerSlave.start();
				}else{
	                System.err.println(getAddress() + " Cannot Connect to " + MngAddress + "due to " + PeerManagerSlave.LastError());
	                GenerateError("Error in Send:" + SMom.SMomUtilities.vbCrLf + PeerManagerSlave.LastError());
	                return false;
	         	}
	            //'Lo aggiungo alla lista
	            mManagers.put(MngAddress,PeerManagerSlave);
	     	}
	        //'Inviare all'host indicato
	        return PeerManagerSlave.SendTCPMessage(Env);
	 	}
	 	return false;
	}

	/***
	 * Funzione chiamata dallo slave nel momento in cui viene chiusa la socket o in altri casi di errore
	 */
	protected void RemoveRemoteHost(CTcpManagerSlave slave){
		mManagers.remove(slave);
		slave.stop();
		slave.destroy();
		slave=null;
	}
	
	/**
	 * Recupera un elemento da una collection se esiste, altrimenti restituisce Nohting
	 */
	private CTcpManagerSlave FindPeerServer(String MngAddress){
		if (mManagers.containsKey(MngAddress))
			return (CTcpManagerSlave)mManagers.get(MngAddress);
		else
			return null;
	}
	
	/**
	 * Funzione chiamata dagli slave in ascolto quando arriva un messaggio
	 */
	protected boolean SendToYou(CEnvelope Env, String RemoteHostAddress){
        if (getDispatcher() != null){
        	//Informazioni di dispatching
	        if (Env.getTraceRoute()==null) Env.setTraceRoute(new SMom.CEnvelopeTrace());
	        Env.getTraceRoute().setLocalMsgManager(this);
	        Env.getTraceRoute().setRemoteMsgManagerAddress(RemoteHostAddress);
            return getDispatcher().msgArrived(Env);
        }else return false;
		
	}
	
	/** 
	 * Indica il numero di manager conosciuti.
	 */
	public int getKnownManagerNumber(){
	    return mManagers.size();
	}
	
	/**
	 * Permette di cominciare ad ascoltare sulla porta indicata i messaggi in ingresso
	 */
	public boolean StartListenforMessages(){
		try{
	    	this.start();
	    	return true;
	    }catch(Exception e){
	    	GenerateError(e.toString());
	    	return false;
	    }
	}
	/**
	 * Metodo che mette in ascolto il server in un thread nuovo attraverso il metodo Start()
	 */
	public void run() {
		try {
			mServerSocket = new java.net.ServerSocket(getPort());
			System.out.println("CTcpManager in ascolto su porta " + getPort());
		
			//Accettazione delle richieste
			while(true) {
				java.net.Socket s;	//Nuova socket che richiede l'accesso
				System.out.println("Server pronto per la richiesta...");
				//Accetto la richiesta
				s = mServerSocket.accept();
				CTcpManagerSlave PeerManagerSlave = new CTcpManagerSlave(this,s);
				mManagers.put(s.getInetAddress().getHostAddress() +':'+s.getPort(),PeerManagerSlave);
				PeerManagerSlave.start();	//Comincio ad ascoltare
			}
		}catch(Exception e){
			//Dovrei giungere qui quando viene chiusa la connessione.
		}
	}

	/**
	 * Permette di cominciare ad ascoltare sulla porta indicata i messaggi in ingresso
	 */
	public void StopListenforMessages(){
	    if (mServerSocket!=null){
	    	try{
				this.stop();
	        	mServerSocket.close();
	     	}catch(Exception e){
	     		GenerateError(e.toString());
	     	}finally{
	     		mServerSocket = null;
	     	}
	 	}
	}
	
	public CTcpManager(int LocalPort) throws java.net.UnknownHostException {
	    mHostData = java.net.InetAddress.getLocalHost();
		mServerPortNumber = LocalPort;
	    mManagers = new java.util.HashMap();
	}

	public CTcpManager()throws java.net.UnknownHostException{
	    this(mDEFAULT_PORT);
	}
}

/***
 * Thread Slave che ascolta la singola connessione verso un Manger remoto.
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
class CTcpManagerSlave extends Thread{
	/**
	 * Manager Master
	 */
	private CTcpManager mTcpManager;
	/**
	 * Socket usata per la connessione punto punto
	 */
	private java.net.Socket s;
	/**
	 * Stream di Uscita per scrivere sulla socket
	 */
	private java.io.PrintStream writer;
	/**
	 * Stream di Entrata per leggere dalla socket
	 */
	private java.io.BufferedReader  reader;
	/**
	 * Ultimo errore rilevato
	 */
	private String mstrLastError;
	/**
	 * Indirizzo Remoto che si sta ascoltando
	 */
	private String mstrRemoteMsgManagerAddress;

	public CTcpManagerSlave(CTcpManager t){
		mTcpManager = t;
	}
	/**
	 * Il costruttore accetta una socket aperta derivata da una Accept del server
	 * Successivamente chiamare il metodo del thread start() per iniziare
	 */
	public CTcpManagerSlave(CTcpManager t,java.net.Socket openSocket) throws java.io.IOException{
		this(t);
		s = openSocket;
		openStreams(s);
	}

	private void openStreams(java.net.Socket sock) throws java.io.IOException{
				
		//Creazione degli oggetti per leggere e scrivere
		mstrRemoteMsgManagerAddress = 
					sock.getInetAddress().getHostAddress() + ':' +
					String.valueOf(sock.getPort());
			
		reader =	new java.io.BufferedReader(new java.io.InputStreamReader(sock.getInputStream()));
		writer =	new java.io.PrintStream(sock.getOutputStream());

	}
	/**
	 * Richiede allo slave di tentare una connessione Client verso l'indirizzo indicato
	 */
	public boolean StartConnecting(String Machine, int portNumber){
		try{
			//Apertura della Socket (terzo parametro indica socket stream)
			//Riutilizzo la porta del server
			s = new java.net.Socket();
			s.setReuseAddress(true);
			//Collego la socket alla stessa porta del server
			s.bind(new java.net.InetSocketAddress(
									java.net.InetAddress.getLocalHost(),
									mTcpManager.getPort()));
			s.connect(new java.net.InetSocketAddress(Machine,portNumber));
			openStreams(s);
			return true;
		}
		catch(Exception e){
			mstrLastError="Errore in StartConnecting " + e.toString();
			return false;
		}
	}


	public String LastError(){
		return mstrLastError;
	}
	
	public boolean SendTCPMessage(CEnvelope env){
		try{
			writer.println(env.toString());
			return true;
		}catch(Exception e){
			mstrLastError="Errore in Scrittura: " + e.toString();
			return false;
		}
	}

	public void run(){
		try{
			do {
				String lettoDaInput = reader.readLine();
				OnDataArrival(lettoDaInput);
			}while (true);
		}
		catch(Exception e){
			mTcpManager.RemoveRemoteHost(this);
		}
	}

	private void OnDataArrival(String message){
		try{
			CEnvelope Env = new CEnvelope(message);
			mTcpManager.SendToYou(Env,mstrRemoteMsgManagerAddress);
		}catch(Exception e){
		}
	}
}