package SMom.MsgManager;
import SMom.*;
import SMom.Dispatcher.IDispatcher;

/** Manager utilizzabile all'interno di una singola applicazione per inviare messaggi ad oggetti locali.
 * <DIV CLASS="ClassDescription">
 *  Questo semplice <I>MsgManager</I> suppone che tutti i messaggi da inviare vengano spediti a un Manager
 *	locale (anche il manager stesso).
 *  Se il messaggio  indirizzato allo stesso Manager, notifica il Dispatcher collegato che
 *    provveder ad inoltrare i messaggi agli oggetti locali destinatari; se, al contrario, il destinatario
 *    un altro manager locale, esegue una <I>Send</I> dello stesso messaggio al destinatario.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public class CLocalManager implements IMsgManager{
	/** Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private IDispatcher mDispatcher;
	/** Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private java.util.Vector mManagers;
	/** Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private String mAddress;
	
	/**
	 *Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public IDispatcher getDispatcher(){
	    return mDispatcher;
	}
	
	/**
	 *Identificativo dell'oggetto che si occuper di indirizzare i messaggi ai destinatari
	 */
	public void setDispatcher(IDispatcher dsptchr){
	    mDispatcher = dsptchr;
	}
	
	/** Indirizzo logico del manager. Identifica il manager specificandolo in maniera univoca
	 * L'indirizzo viene generato automaticamente alla creazione dell'oggetto.
	 */
	public String getAddress(){
	    return mAddress;
	}
	
	/** La funzione ignora il MngAddress
	 * Restituisce False se il manager non  nell'elenco dei manager registrati.
	 * Se il manager destinazione  vuoto o  l'oggetto stesso, restituisce False se il Dispatcher non  stato specificato.
	 */
	public boolean Send(CEnvelope Env, String MngAddress){
		int 		Index=0;
		CLocalManager Manager;
    	
    	//Informazioni di dispatching
    	if (Env.getTraceRoute()==null)
    		Env.setTraceRoute(new SMom.CEnvelopeTrace(getAddress()));
    	else
    		Env.getTraceRoute().setRemoteMsgManagerAddress(getAddress());
		
	    //Controllo se sono io
	    if ((MngAddress==null ) || (MngAddress.equalsIgnoreCase(""))  || (MngAddress.equals(getAddress()))){
	    	return SendToYou(Env);
		}else{
	        //Cerco fra altri managers registrati
	        for (Index = 0; Index < mManagers.size();Index++){
	            Manager = (CLocalManager)mManagers.elementAt(Index);
	            if (Manager.getAddress().equals(MngAddress))
	                return Manager.SendToYou(Env);
	        }
		}
		return false;
	}
	
	/**
	 * Funzione chiamata dagli altri manager locali indicando che il messaggio  per me
	 */
	protected boolean SendToYou(CEnvelope Env){
        if (getDispatcher() != null){
        	//Informazioni di dispatching
	        if (Env.getTraceRoute()==null) Env.setTraceRoute(new SMom.CEnvelopeTrace());
	        Env.getTraceRoute().setLocalMsgManager(this);
            return getDispatcher().msgArrived(Env);
        }else return false;
		
	}
	
	/**
	 * Indica il numero di manager conosciuti.
	 */
	public int getKnownManagerNumber(){
	    return mManagers.size();
	}
	
	/**
	 * Funzione che permette di registrare un ulteriore Manager locale per la notifica di messaggi.
	 * Se il manager  gi registrato non verr aggiunto ma la funzione restituir comunque true.
	 */
	public boolean Register(CLocalManager OtherManager){
	    mManagers.addElement(OtherManager);
	    return true;
	}
	
	/**
	 * Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
	 * Se il manager non risulta registrato la funzione restituir comunque true.
	 */
	public boolean UnRegister(CLocalManager OtherManager){
	    mManagers.removeElement(OtherManager);
	    return true;
	}
	
	/**
	 * Consente di sapere se un Manager  registrato. Restituisce 0 se il manager non  registrato, un numero maggiore di 0 in caso contrario
	 */
	public int IsRegistered(CLocalManager OtherManager){
	    return mManagers.indexOf(OtherManager);
	}
	
	/**
	 * Crea un nuovo manager locale con indirizzo predefinito univoco
	 */
	public CLocalManager(){
	    mAddress = "LocalManager|" + SMom.SMomUtilities.getUniqueIdentifier();
	    mManagers = new java.util.Vector();
	}
}