package SMom.Exceptions;

import SMom.Exceptions.CRemoteException;

/**
 * Eccezione generata da un oggetto remoto ma la cui descrizione non  stata specificata.
 * <DIV CLASS="ClassDescription">
 *  Viene generata quando l'oggetto remoto invia un messaggio senza specificare il motivo del fallimento.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public class CUnKnownRemoteException extends CRemoteException {
    /**
     *	Messaggio standard per l'eccezione corrente
     */
    protected static String ERROR_MESSAGE = "Remote Object Raised Unexplained Exception!";
    
    /**
     * Costruttore con messaggio di errore standard
     */
	public CUnKnownRemoteException() {
		this(null,null);
	}

	/**
	 * Costruttore che permette di personalizzare il messaggio di errore e l'origine dell'errore
	 */
	public CUnKnownRemoteException(String Source, String MsgErrore){
		super(Source,MsgErrore);
	}	
}
