package SMom.Exceptions;

/**
 * Eccezione generica del servizio Simple Message Oriented Middleware.
 * <DIV CLASS="ClassDescription">
 *  Ogni eccezione lanciata dal servizio discende da questa.
 *	Una eccezione di questo tipo non definisce il motivo reale che ha causato l'eccezione.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public class CSMomException extends Exception {
	/**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int UnKnownSMomException = 10600;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int ReceiverNotFoundException = 10601;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int DispatcherNotFoundException = 10602;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int MsgManagerNotFoundException = 10603;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int TimeOutExpiredException = 10700;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int MethodNotFoundException = 10701;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int VarTypeUnKnownException = 10702;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int InvalidTraceRouteDataException = 10703;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int TooManyArgumentsForCallByName = 10704;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int RemoteException = 10705;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int UnKnownRemoteException = 10706;
    
    /**
	 *	Codice di errore lanciato dal servizio SMom
	 */
    public static final int CannotConvertStringToEnvelope = 10900;
    
    /**
     *	Messaggio standard per l'eccezione corrente
     */
    protected static String ERROR_MESSAGE = "Generic SMom Exception!";
    
    /**
     * Costruttore con messaggio di errore standard
     */
	public CSMomException() {
		this(null,null);
	}

	/**
	 * Costruttore che permette di personalizzare il messaggio di errore e l'origine dell'errore
	 */
	public CSMomException(String Source, String MsgErrore){
		super(
			((MsgErrore==null)?"":MsgErrore + "\r\n") + 
			ERROR_MESSAGE + 
			((Source==null)?"":"\r\nSource:" + Source));
	}
	
	/**
	 * Permette di generare una eccezione con un commento standard.
	 * E' possibile aggiungere una descrizione aggiuntiva mediante il parametro MsgErrore
	 */
	public static void RaiseSMomException(int ErrorCode, String Source, String MsgErrore) throws CSMomException{
		throw getSMomException(ErrorCode,Source,MsgErrore);
	}
	
	/**
	 * Restituisce un oggetto eccezione definito tramite il codice standard.
	 */
	protected static CSMomException getSMomException(int ErrorCode, String Source, String MsgErrore){
		switch(ErrorCode){
			case CannotConvertStringToEnvelope:
				return new SMom.Exceptions.CCannotConvertStringToEnvelopeException(Source,MsgErrore);
			/*
			case ReceiverNotFoundException
	            GetStandardSMomExceptionDescription = "Receiver not Found!"
	        case DispatcherNotFoundException
	            GetStandardSMomExceptionDescription = "Dispatcher is not set!"
	        case MsgManagerNotFoundException
	            GetStandardSMomExceptionDescription = "Manager could'nt be found!"
	        case TimeOutExpiredException
	            GetStandardSMomExceptionDescription = "TimeOut for Remote Invocation has expired!"
	        case MethodNotFoundException
	            GetStandardSMomExceptionDescription = "Method not Found in Servant!"
	        case InvalidTraceRouteDataException
	            GetStandardSMomExceptionDescription = "TraceRoute data are not available or are incomplete!"
	        case TooManyArgumentsForCallByName
	            GetStandardSMomExceptionDescription = "CDynamicSkeleton can handle functions whit less then 11 args!"
	        case RemoteException
	            GetStandardSMomExceptionDescription = "Remote Object generated Exception!"
	        
	        case UnKnownRemoteException:
	            return new SMom.Exceptions. "Remote Object generated Exception without description!"
	         */
	         default:
	            return new CSMomException(Source,MsgErrore);
	 	}
	}
}
