package SMom.Dispatcher;
import SMom.*;
import SMom.MsgManager.IMsgManager;
/**
 * Interfaccia di un Dispatcher di messaggi.
 * <DIV CLASS="ClassDescription">
 *  Un Dispatcher consente di decidere le <EN>politiche</EN> per l'invio e la ricezione di messaggi _
    (es: lavorare in maniera sincrona/asincrona, decidere quante code di entrate/uscita usare, ecc...).
 *  L'oggetto utilizza un <I>MsgManager</I> per inviare fisicamente i messaggi utilizzando quindi i _
    <EN>meccanismi</EN> di spedizione implementati da tale oggetto.
 *  Se alla richiesta di invio di un messaggio non  ancora stato collegato un MsgManager, il messaggio verr scartato.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public interface IDispatcher{
	/**
	 * Identificativo dell'oggetto che si occuper di spedire i messaggi ai destinatari
	 */
	public IMsgManager getMsgManager();
	
	/**
	 * Identificativo dell'oggetto che si occuper di spedire i messaggi ai destinatari
	 */
	public void setMsgManager(IMsgManager dsptchr);
	
	/**
	 *Funzione che permette ad un possibile destinatario di messaggi, di registrarsi presso il dispatcher
	 */
	public boolean Register(IReceiver Receiver);
	
	/**
	 * Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
	 */
	public boolean UnRegister(IReceiver Receiver);
	
	/**
	 * Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
	 */
	public boolean UnRegister(String ReceiverObjectID);
	
	/**
	 *Funzione di CallBack chiamata dal Manager che richiede al dispatcher di inviare il messaggio ad uno dei riceventi registratisi
	 */
	public boolean msgArrived(CEnvelope Env);
	
	/***
	 * Funzione che permette di inviare un messaggio ad un Manager di messaggi destinatario
	 * <B>Per poter inviare un messaggio  necessario aver legato il dispatcher ad un MsgManager!</B>
	 * Restituisce False se l'invio non va a buon fine. Le implementazioni di questa interfaccia 
	 * indicheranno i motivi specifici per cui  possibile che si verifichi un errore (esempio: Manager _
	 * destinazione sconosciuto)
	 */
	public boolean Send(CEnvelope Env,String MngAddress);
}