package SMom.Dispatcher;
import SMom.*;
import SMom.MsgManager.IMsgManager;
/** Semplice Dispatcher di messaggi sincrono e sequenziale.
 * <DIV CLASS="ClassDescription">
 *	Le richieste vengono immediatamente inviate al MsgManager per essere eseguite.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public class CSinchronusAndSequentialDispatcher implements IDispatcher{
	/**
	 *Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private IMsgManager mMsgManager;
	
	/**
	 *Variabile contenente il valore della propriet omonima dell'oggetto
	 */
	private java.util.Vector mReceivers;
	
	/**
	 *Identificativo dell'oggetto che si occuper di spedire i messaggi ai destinatari
	 */
	public IMsgManager getMsgManager(){
	    return mMsgManager;
	 }
	
	/**
	 *Identificativo dell'oggetto che si occuper di spedire i messaggi ai destinatari
	 */
	public void setMsgManager(IMsgManager msgMngr){
	    mMsgManager = msgMngr;
	}
	
	/**
	 *Funzione che permette ad un possibile destinatario di messaggi, di registrarsi presso il dispatcher
	 */
	public boolean Register(IReceiver Receiver){
	    mReceivers.addElement(Receiver);
	    return true;
	}
	
	/**
	 *Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
	 */
	public boolean UnRegister(IReceiver Receiver){
	    mReceivers.removeElement(Receiver);
	    return true;
	}
	
	
	/**
	 * Funzione che permette ad un possibile destinatario di messaggi, precedentemente registratosi, di deregistrarsi presso il dispatcher
	 */
	public boolean UnRegister(String ReceiverObjectID){
		java.util.Enumeration e = mReceivers.elements();
		while (e.hasMoreElements()){
			IReceiver next = (IReceiver)e.nextElement();
			if (next.getObjectID().equals(ReceiverObjectID))
				return UnRegister(next);
		}
		return false;
	}

	/**
	 *Invia il messaggio ad uno dei riceventi registrati
	 */
	public boolean msgArrived(CEnvelope Env){
		int Index=0;
		IReceiver Receiver;
	    //Cerco fra altri managers registrati
	    for(Index = 0; Index< mReceivers.size(); Index++){
	        Receiver = (IReceiver)mReceivers.elementAt(Index);
	        if (Receiver.getObjectID().equals(Env.getReceiver().getObjectID())){
	            Receiver.msgArrived(Env);
	            return true;
	     	}
	 	}
	 	return false;
	}
	
	/**
	 *Spedice al manager la richiesta di invio in maniera sequenziale e sincrona.
	 */
	public boolean Send(CEnvelope Env, String MngAddress){
	    if (getMsgManager() != null)
	    	return getMsgManager().Send(Env, MngAddress);
	    else return false;
	}
	/**
	 * Costruttore di default della classe
	 */
	public CSinchronusAndSequentialDispatcher(){
	    mReceivers = new java.util.Vector();
	}
	
	protected void finalize(){
	    //mReceivers.clear();
	    mReceivers = null;
	}
}