package SMom;
import SMom.Dispatcher.IDispatcher;
import SMom.MsgManager.IMsgManager;

/**
 * Classe contenente informazioni utili per la tracciabilit della lettera.
 * <DIV CLASS="ClassDescription">
 *  Le informazioni utili per la tracciabilit della Envelope vengono aggiunte da Dispatcher
 *  e MsgManager di ricezione.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class CEnvelopeTrace{
	/**
	 *	Attributo contenente il valore della propriet omonima dell'oggetto
	 */
	private String		mRemoteMsgManager;   
	
	/**
	 *	Attributo contenente il valore della propriet omonima dell'oggetto
	 */
	private IDispatcher	mLocalDispatcher;
	
	/**
	 *	Attributo contenente il valore della propriet omonima dell'oggetto
	 */
	private IMsgManager	mLocalMsgManager;
	
	/**
	 * Costruttore vuoto
	 */
	public CEnvelopeTrace(){
	}
	
	/**
	 * Crea un nuovo pacchetto di traccia impostando il MsgManager remoto che ha inviato il messaggio
	 */
	public CEnvelopeTrace(String RemoteMsgManagerAddress){
		setRemoteMsgManagerAddress(RemoteMsgManagerAddress);
	}
	
	/**
	 * Identificativo del dispatcher che ha consegnato il messaggio.
	 * Attributo utile per motivi di tracciabilit.
	 */
	public IDispatcher getLocalDispatcher(){
	    return mLocalDispatcher;
	}
	
	/**
	 * Identificativo del dispatcher che ha consegnato il messaggio.
	 * Attributo utile per motivi di tracciabilit.
	 */
	public void setLocalDispatcher(IDispatcher sndr){
	    mLocalDispatcher = sndr;
	}
	
	/**
	 * Identificativo del Manager che ha consegnato il messaggio.
	 * Attributo utile per motivi di tracciabilit.
	 */
	public IMsgManager getLocalMsgManager(){
	    return mLocalMsgManager;
	}
	
	/**
	 * Identificativo del Manager che ha consegnato il messaggio.
	 * Attributo utile per motivi di tracciabilit
	 */
	public void setLocalMsgManager(IMsgManager sndr){
	    mLocalMsgManager = sndr;
	}
	
	/**
	 * Identificativo del Manager remoto che ha consegnato il messaggio.
	 * Attributo utile per motivi di tracciabilit
	 */
	public String getRemoteMsgManagerAddress(){
	    return mRemoteMsgManager;
	}
	
	/**
	 * Identificativo del Manager remoto che ha consegnato il messaggio
	 * Attributo utile per motivi di tracciabilit
	 */
	public void setRemoteMsgManagerAddress(String sndr){
	    mRemoteMsgManager = sndr;
	}
}
