package SMom;
/**
 * Rappresentazione di una busta (lettera) tramite cui si inviano messaggi con il middleware.
 * <DIV CLASS="ClassDescription">
 *  La classe rappresenta una busta a livello applicativo. A basso livello il messaggio 
 *  verr incapsulato in maniera differente a seconda del Canale usato per la spedizione.
 *  In fase di ricezione il messaggio viene ricreato prima di consegnarlo al ricevente e 
 *  alla busta vengono aggiunte le informazioni di tracciabilit per consentire un <B>Replay</B> 
 *  del messaggio in maniera quanto pi automatica possibile.
 * </DIV>
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
*/
public class CEnvelope{
	
	/**
	 * Carattere usato come delimitatore per le intestazioni dei messaggi
	 */
	protected static String CharDelimiter = ":";
	
	/**
	 *Attributo contenente il valore della propriet omonima dell'oggetto
	 */
	private ISender mSender;
	
	/**
	 *Attributo contenente il valore della propriet omonima dell'oggetto
	 */
	private IReceiver mReceiver;
	
	/**
	 *Attributo contenente il valore della propriet omonima dell'oggetto
	 */
	private String mstrMessage;

	/**
	 *	Attributo contenente il valore della propriet omonima dell'oggetto.
	 */
	private CEnvelopeTrace mTraceRoute;
		
	/**
	 * Costruisce una CEnvelope assegnandole gi i valori necessari
	 */
	public CEnvelope(ISender Sender, IReceiver Receiver, String Message){
		mSender = Sender;
		mReceiver = Receiver;
		mstrMessage = Message;
	}

	/**
	 * Costruisce una CEnvelope assegnandole gi i valori necessari.
	 * Il Ricevente viene posto ad un oggetto di comodo con ObjectID quello indicato
	 */
	public CEnvelope(ISender Sender, String ReceiverObjID, String Message){
		this(Sender, new SMom.CEmptySender(ReceiverObjID), Message);
	}

	/**
	 * Costruttore di default della busta vuota
	 */
	public CEnvelope(){
		mSender = null;
		mReceiver = null;
		mstrMessage = "";
	}
	
	/**
	 * Tenta di costruire una Envelope dalla sua rappresentazione in forma di stringa.
	 * Pu essere lanciata una eccezione in caso di impossibilit.
	 */
	public CEnvelope(String StringEnvelope) throws SMom.Exceptions.CCannotConvertStringToEnvelopeException{
		if (!fromString(StringEnvelope))
			throw new SMom.Exceptions.CCannotConvertStringToEnvelopeException("SMom.CEnvelope",StringEnvelope);
	}

	/**
	 *	Informazioni per la tracciabilit del messaggio.
	 *  Questo attributo viene valorizzato dal Manager e dal Dispatcher di ricezione.
	 */
	public CEnvelopeTrace getTraceRoute(){
	    return mTraceRoute;
	}
	
	/**
	 *	Informazioni per la tracciabilit del messaggio.
	 *	Questo attributo viene valorizzato dal Manager e dal Dispatcher di ricezione.
	 */
	public void setTraceRoute(CEnvelopeTrace sndr){
	    mTraceRoute = sndr;
	}

	/**
	 *	Identificativo del mittente del messaggio
	 */
	public ISender getSender(){
	    return mSender;
	}
	
	/**
	 *	Identificativo del mittente del messaggio
	 */
	public void setSender(ISender sndr){
	    mSender = sndr;
	}
	
	/**
	 *	Identificativo del destinatario del messaggio
	 */
	public IReceiver getReceiver(){
	    return mReceiver;
	}
	
	/**
	 *	Identificativo del destinatario del messaggio
	 */
	public void setReceiver(IReceiver rcvr){
	    mReceiver = rcvr;
	}

	/**
	 * Setta come ricevente un semplice segnaposto con l'ID indicato
	 */
	public void setReceiverByObjectID(String sObjID){
	    setReceiver(new CEmptySender(sObjID));
	}

	/**
	 *	Rappresentazione in forma di stringa del messaggio da inviare
	 */
	public String getMessage(){
	    return mstrMessage;
	}
	
	/**
	 *Rappresentazione in forma di stringa del messaggio da inviare
	 */
	public void setMessage(String msg){
	    mstrMessage = msg;
	}
	
	/**
	 *	Permette di recuperare una rappresentazione in forma di stringa dell'oggetto
	 *	formato:
	 * 	<SenderObjIDLen><CharDelimiter><ReceiverObjIDLen><CharDelimiter><MessageLen><CharDelimiter><SenderObjID><ReceiverObjID><Message>
	 */
	public String toString(){
		return String.valueOf(getSender().getObjectID().length()) + CharDelimiter + 
	                String.valueOf(getReceiver().getObjectID().length()) + CharDelimiter + 
	                String.valueOf(getMessage().length()) + CharDelimiter + 
	                getSender().getObjectID() + 
	                getReceiver().getObjectID() + 
	                getMessage();
	}
	
	/**
	 * Permette di creare un oggetto CEnvelope ottenendo i dati dalla rappresentazione in forma di stringa.
	 */
	private boolean fromString(String StrEnvelope){
		try{
			//char[] s = {'|'};
			//String[] pezzi = StrEnvelope.Split(s,4);
			String[] pezzi = StrEnvelope.split(CharDelimiter,4);
			int lenSender = Integer.parseInt(pezzi[0]);
			int lenReceiver = Integer.parseInt(pezzi[1]);
			int lenMessage = Integer.parseInt(pezzi[2]);
			int headerLenght = pezzi[0].length() + pezzi[1].length() + pezzi[2].length() + 3;
			setSender(new SMom.CEmptySender(StrEnvelope.substring(headerLenght,headerLenght+lenSender)));
			setReceiver(new SMom.CEmptySender(StrEnvelope.substring(headerLenght+lenSender,headerLenght+lenSender+lenReceiver)));
			setMessage(StrEnvelope.substring(headerLenght+lenSender+lenReceiver,headerLenght+lenSender+lenReceiver+lenMessage));
			return true;
		}catch(Exception e){
			return false;
		}
	}

	/**
	 * Grazie alle funzionalit di tracciabilit  possibile rispondere al messaggio
	 * semplicemente indicando il messaggio di ritorno.
	 * La funzione restituisce il risultato della Send applicata al MsgManager locale che ha
	 * ricevuto il messaggio.
	 * Non  ovviamente garantito che il MsgManager di origine conosca il Receiver.
	 */
	public boolean Replay(String Message, ISender MsgSender){
		ISender snd;
	    //Se non  specificato il Sender ne creo uno fittizio
	    if (MsgSender == null)
	    	snd = new CEmptySender(getReceiver().getObjectID());
	    else
	        snd = MsgSender;

	    //Spedisco il messaggio al MsgManager locale con indirizzo il MsgManager remoto
	    return getTraceRoute().getLocalMsgManager().Send(
	            new CEnvelope(MsgSender, getSender().getObjectID(), Message),
	            getTraceRoute().getRemoteMsgManagerAddress());
	
	}

}