//Title:        casella.java
//Copyright:    BGSoftware 2000
//Author:       Giorgio Bernardi
//Company:      BGSoftware
//Description:  Casella della Battaglia Navale 1.0
package NavalBattle;
import java.awt.*;

/***
 * <font color="#FF0000">
 * <b><center><h1>Battaglia Navale 1.0</h1></center></b>
 * @version 	 maggio 2000
 * @author 		 <b>Giorgio Bernardi</b>.<br>E-Mail: <a href="mailto:BGSoftware@hotmail.com">BGSoftware@hotmail.com</a><br>Web: <a href="http://Giorgio_Bernardi.tripod.com/">http://Giorgio_Bernardi.tripod.com/</a>
 * </font>
 * <hr>
 * Classe che rappresenta una casella del campo di gioco.
*/
public class casella extends Label{

	/***
	* Il colore della barca Colpita.
	*/
	static Color Colpita	= new Color ( 250, 0, 0);		//il colore di una barca colpita
	/***
	* Il colore della barca Non Colpita (solo Acqua).
	*/
	static Color NonColpita	= new Color( 0, 190, 255); //il colore dell'acqua
	/***
	* Il colore della barca.
	*/
	static Color Barca		= new Color( 90, 20, 34); //il colore di una barca non colpita
	/***
	* Il colore della barca Affondata.
	*/
	static Color Affondata	= new Color( 0, 120, 255); //il colore di una barca affondata

	/***
	* La prima coordinata della casella.
	*/
	private int riga;
	/***
	* La seconda coordinata della casella.
	*/
	private int colonna;
	/***
	* Indica se la casella appartiene al campo di attacco dell'utente o alla difesa.
	*/
	private boolean attacco;
	/***
	* Indica se la casella  gi stata giocata<br>Per il computer indica se pu giocare questa casella o meno.
	*/
	private boolean giaGiocata;

	/***
	* Costruttore della casella.<br>Vengono indicate riga, colonna e campo della casella.
	*/
	public casella(int row, int col, boolean attack){
		super("", 1);
		riga=row; colonna=col; attacco=attack; giaGiocata=false; setBackground(NonColpita);
		setForeground(new Color(255,255,255) ); setFont(new Font("Arial", Font.BOLD, 16) );
	}

	/***
	* Restituisce la riga di appartenenza della casella.
	*/
	public int getRow(){
		return riga;
	}

	/***
	* Restituisce la colonna di appartenenza della casella.
	*/
	public int getCol(){
		return colonna;
	}

	/***
	* Indica se la casella appartiene al campo di attacco dell'utente (o a quello di difesa).
	*/
	public boolean getAtt(){
		return attacco;
	}

	/***
	* Indica se  presente una parte di una barca nella casella.
	*/
	public boolean isBoat(){
		return ( (this.getText()).startsWith("X") ); //se comincia con X c' la barca (true)
	}

	/***
	* Indica se la casella  gi stata giocata.
	*/
	public boolean isShot(){
		return giaGiocata;
	}

	/***
	* Imposta la casella come <i>gia giocata</i>. In questo modo il computer non la richiamer.<br>Viene utilizzata nel 2 livello di gioco quando la casella non deve essere colpita pur non avendola ancora giocata.
	*/
	public void setShot(){
		giaGiocata=true;
	}

	/***
	* Inserisce una barca nella casella.
	*/
	public void setBoat(){
		setText("X");
		setBackground(Barca);

	}

	/***
	* Imposta la casella con il layout di una barca affondata.
	*/
	public void setKilled(){
		setBackground(Affondata);
	}

	/***
	* Rimuove la barca dalla casella se presente.
	*/
	public void remBoat(){
		setText("");
		setBackground(NonColpita);
	}

	/***
	* Imposta la casella come <i>gia gicata</i> e la visualizza come tale sia nel caso in cui ci sia una barca sia che non ci sia una barca.<br>Restituisce <i>true</i> se era presente una barca.
	*/
	public boolean shoot(){ //restituisce se l'ho colpita o non c'era
		giaGiocata=true;
		if ( isBoat() ){setBackground(Colpita); return true;}
		else { setText("O"); return false;}
	}
}