//Title:        MyRandom.java
//Copyright:    BGSoftware 2000
//Author:       Giorgio Bernardi
//Company:      BGSoftware
//Description:  Generatore di numeri casuali
package NavalBattle;

import java.io.Serializable;
/**
 * <font color="#FF0000">
 * <b><center><h1>MyRandom</h1></center></b></font>
*/
public class MyRandom implements Serializable{

//Variabili globali
private long seed;
private static long multiplier = 0x5deece66dL;
private static long addend = 11L;
private static long mask = 0xffffffffffffL;
private static int BITS_PER_BYTE = 8;
private static int BYTES_PER_INT = 4;
private double nextNextGaussian;
private boolean haveNextNextGaussian;

/***
* Inizializza la classe utilizzando il Timer del sistema.
*/
public MyRandom(){ this(System.currentTimeMillis() ); }

/***
* Inizializza la classe utilizzando <i>Seed</i>.
*/
public MyRandom(long Seed){
	haveNextNextGaussian = false;
	setSeed(Seed);
}

/***
* Cambia l'inizializzatore dell'istanza.
*/
public synchronized void setSeed(long Seed){
	seed = ( Seed ^ 0x5deece66dL) & 0xffffffffffffL;
	haveNextNextGaussian = false;
}

/***
* Restituisce un Intero (a 32 bit) positivo o negativo.
*/
public int nextInt(){
	return next(32);
}

/***
* Restituisce un numero <b>intero positivo</b> nel seguente intervallo:<br><center><b>0 <= <i>x</i> < max </center><br> Notare che il valore  sempre <b>minore</b> di max!
*/
public int nextInt(int max){
	return next(10) * max / 1024;
}

/***
* Restituisce un float.
*/
public float nextFloat(){
	int i = next(24);
	return (float) i / 1.677722E+007F;
}

/***
* Restituisce un long.
*/
public long nextLong(){
	return ((long) next(32) << 32) + (long) next(32);
}

/***
* Restituisce un intero a <i>n</i> bit.
*/
private synchronized int next (int n){
	long num = seed * 0x5deece66dL + 11L & 0xffffffffffffL;
	seed = num;
	return (int) (num >>> 48 - n);
}

/***
* Restituisce un valore di tipo byte.
*/
public void nextBytes(byte abyte0[]){
	int i = abyte0.length;
	int j = 0;
	int k = 0;

	do{
		int l = 0;
		do{
			if (j==1) return;
			k = l != 0 ? k>>8 : next(32);
			abyte0[j++] = (byte)k;
		}while(++l < 4);
	}while(true);
}

public synchronized double nextGaussian(){
	if ( haveNextNextGaussian ){
		haveNextNextGaussian=false;
		return nextNextGaussian;
	}

	double d; double d1; double d2;
	do{
		d = 2D * nextDouble() - 1.0D;
		d1 = 2D * nextDouble() - 1.0D;
		d2 = d * d +d1 *d1;
	}while(d2 >= 1.0D);

	double d3 = Math.sqrt( ( -2D * Math.log(d2) ) /d2);
	nextNextGaussian = d1*d3;
	haveNextNextGaussian=true;
	return d * d3;
}

/***
* Restituisce un double.
*/
public double nextDouble(){
	long l = ((long) next(26) << 27) + (long) next(27);
	return (double)l / 9007199254740992D;
}

/***
* Restituisce un valore di tipo boolean.
*/
public boolean nextBoolean(){
	int b = next(6);
	return (b /2 *2 == b );
}
}//End Class
