//Title:        BattagliaNavale.java
//Copyright:    BGSoftware 2000
//Author:       Giorgio Bernardi
//Company:      BGSoftware
//Description:  Gioco della Battaglia Navale 1.2
package NavalBattle;
import java.awt.*;
/***
 * <font color="#FF0000">
 * <b><center><h1>Battaglia Navale 1.1</h1></center></b></font>

 * <hr>
 * Questo Programma  stato creato con il Java Developement Kit 1.2.2. Ha necessariamente bisogno della classe <b>java.util.Random.class</b>.<br>
 * Funziona sia come programma Stand Alone che come Applet. Non ha bisogno di parametri in ingresso.<br><br>
 * <b>Istruzioni (contenute anche all'interno del programma</b><br>
 * Per giocare alla Battaglia Navale, selezionate il numero di caselle
 * di larghezza e altezza per il vostro campo di gioco (10 per Default).<br>
 * Poi selezionate il numero di barche di ogni lunghezza. STATE ATTENTI perch se il
 * terreno  troppo piccolo rispetto al numero di barche da inserire,il computer potrebbe
 * avere dei problemi nel posizionare le sue, quindi Attenzione!<br>
 * Scegliete il livello di difficolt e premete 'Inizio Partita'
 * I messaggi in basso nello schermo vi indicano i passi da seguire: ora disponete
 * le vostre barche cliccando sulla tabella di sinistra che dovrebbe essere apparsa.<br>
 * Quando avete disposto le vostre barche cliccate sul bottone di prima con scritto
 * 'Comincia!'. Se il computer si accorge che vi siete sbagliati a posizionare le
 * barche (ne avete attaccate due oppure le avete legate per un vertice o ne avete messo un
 * numero sbagliato) ve lo dir, altrimenti vi dir che potete cominciare.<br>
 * Cliccate sulla tabella a destra. Anche il computer far la sua puntata e vi fornir
 * il risultato di questa prima giocata.<br>
 * Il gioco va avanti fino a quando uno dei due non colpisce tutte le barche dell'avversario!<br>
 * Un pezzo di nave rosso, significa colpita, se diventa azzurro-blu tutta la barca significa
 * che  stata affondata.<br>
 * In ogni momento potete terminare la partita con l'apposito bottone.<br><hr>
 * <font color="#FF0000"><BR>
 * @version 	 maggio 2000
 * @author 		 <b>Giorgio Bernardi</b>.<br>E-Mail: <a href="mailto:BGSoftware@hotmail.com">BGSoftware@hotmail.com</a><br>Web: <a href="http://Giorgio_Bernardi.tripod.com/">http://Giorgio_Bernardi.tripod.com/</a>
 * </font>
*/
public class BattagliaNavale extends java.applet.Applet implements java.awt.event.ActionListener, java.awt.event.MouseListener{

//Variabili globali
private Button Cm_Start;				//Il bottone di controllo
private Button Cm_Istruzioni;			//Il bottone di istruzioni

private CheckboxGroup cbg = new CheckboxGroup();	//Contenitore di livelli
private Checkbox Opzione[]={new Checkbox("Livello Facile", cbg, true),new Checkbox("Livello Medio", cbg, false),new Checkbox("Livello Difficile", cbg, false)}; //livelli
private TextField MaxRigheStr = new TextField("10", 2);		//Contenitore del numero di righe e colonne
private TextField T_BdaQuattro= new TextField("1");			//Barche da Quattro	(input)
private TextField T_BdaTre= new TextField("2");				//Barche da Tre		(input)
private TextField T_BdaDue= new TextField("3");				//Barche da Due		(input)
private TextField T_BdaUno= new TextField("4");				//Barche da Uno		(input)
private int BdaQuattro	=1;									//Barche da Quattro	(Default)
private int BdaTre		=2;									//Barche da Tre		(Default)
private int BdaDue		=3;									//Barche da Due		(Default)
private int BdaUno		=4;									//Barche da Uno		(Default)

private Panel mainPanel;									//Il pannello di gioco
private Color BackColor = new Color ( 0, 185, 0);			//il colore di sfondo
private Label output = new Label("Qui appariranno le istruzioni di volta in volta!",1); //la Label di output

private boolean BarcheCom[][];			//le posizioni delle barche del computer

private int DaColpireCom;				//il numero di caselle ancora da colpire. Se == 0 finisce il gioco
private int DaColpireUt;				//il numero di caselle ancora da colpire. Se == 0 finisce il gioco

private casella CasellaUt[][];			//la scacchiera dell'utente
private casella CasellaUtAtt[][];		//la scacchiera di attacco dell'utente

private int MaxRighe = 10;					//le righe (e colonne) della scacchiera (10 default)
private boolean gara = false;				//True se la partita  in corso
private boolean possoCliccare = false;		//determina quando l'utente pu cliccare sulla tabella
private boolean turno = false;				//true se  il turno dell'utente
private int hoColpitoInPrecedenza[] = {-1,-1}; //barca colpita nell'ultimo tentativo dal computer (-1,-1) significa nessuna

//private java.util.Random num=new java.util.Random(); 	//la classe che genera numeri casuali
private MyRandom num = new MyRandom();					//la classe che genera numeri casuali
private boolean init=false;								//Indica se l'applet  gi stata inizializzata


	/***
	*	Questo elemento riceve gli input del Mouse sui bottoni.
	*/
	public void actionPerformed(java.awt.event.ActionEvent e){
		if ( ( ((Button)e.getSource()).getLabel()).startsWith("I") )
			ShowIstruzioni(); //se  il pulsante di Informazioni
		else{// il bottone principale
			if (gara==false && possoCliccare){
				output.setText("Controllo le tue barche...");
				int a = richiestaInizio();
				if (a == 3)	output.setText("Errore nel numero di Barche. Riprova!");
				if (a == 2)	output.setText("Controlla il posizionamento delle barche e riprova!");
				if (a == 1)	{output.setText("Le Barche sono posizionate correttamente...Attendere!"); preparaMieNavi(); segnaCaselleLateraliUt(); InizioGara();}
				}
			else{
				if (possoCliccare==false) 	NuovaPartita();
				if (gara) 					VoglioSmettere();
			}
		}//fine else
	}

	/***
	*	Elemento richiesto ma NON utilizzato dal programma.
	*/
	public void mouseClicked(java.awt.event.MouseEvent e){}

	/***
	*	Elemento richiesto ma NON utilizzato dal programma.
	*/
	public void mouseReleased(java.awt.event.MouseEvent e){}
	/***
	*	Elemento richiesto ma NON utilizzato dal programma.
	*/
	public void mouseEntered(java.awt.event.MouseEvent e){}
	/***
	*	Questo elemento riceve gli input del Mouse sulle Tabelle di gioco.
	*/
	public void mousePressed(java.awt.event.MouseEvent e){
		if (possoCliccare){
			casella temp = (casella) e.getSource();
			if (gara == false && temp.getAtt()== false) //si stanno preparando le barche Ok
				preparaBarcheUtente(temp.getRow(), temp.getCol());
			else{
				if ( gara && turno && temp.getAtt() ) //se  in gara ed  il suo turno e ha clicca
					attaccoUtente( temp.getRow(), temp.getCol() );
				}
		}

	}
	/***
	*	Elemento richiesto ma NON utilizzato dal programma.
	*/
	public void mouseExited(java.awt.event.MouseEvent e){}

	/***
	 *	Mostra le istruzioni al gioco
	 */
	public void ShowIstruzioni(){
		new frame();
	}
	
	/***
	*	Inizializzazione dell'applet. Prepara la grandezza dello schermo e i pannelli di gioco e di opzione.
	*/
	public void init(){
		init=true;
		resize(700,300);
		setLayout(new BorderLayout());
		setBackground(BackColor );
		add (creaOptionPanel(), "West");
		mainPanel = creaMainPanel();
		validate();
	}

	private Panel creaOptionPanel(){ 	//crea il Pannello di Opzione sulla sinistra e lo restituisce
		Panel optPanel = new Panel();	//Il pannello stesso

		//Preparazione Pannello
		optPanel.setBackground( BackColor );
		optPanel.setLayout(new GridLayout(14, 1));

		//Bottone di controllo
		Cm_Start = new Button("Nuova Partita");
		Cm_Start.setBackground( new Color ( 153, 195, 230) );
		Cm_Start.addActionListener(this);
		optPanel.add(Cm_Start);

		//Bottone di istruzioni
		Cm_Istruzioni = new Button("Istruzioni");
		Cm_Istruzioni.setBackground( new Color ( 153, 195, 230) );
		Cm_Istruzioni.addActionListener(this);
		optPanel.add(Cm_Istruzioni);

		//Input Lato Scacchiera
		optPanel.add(new Label("Numero di caselle per"));
		optPanel.add(new Label("lato nella scacchiera"));
		optPanel.add(MaxRigheStr);

		//Livelli di gioco
		optPanel.add(new Label("Scegli il livello:"));
		for (int i=0; i<3; i++){
			Opzione[i].setBackground(BackColor );
			optPanel.add(Opzione[i]);}

		//Numero di Barche
		optPanel.add(new Label("Numero di Barche..."));

		Panel P_Temp = new Panel();
		P_Temp.setBackground( BackColor );
		P_Temp.setLayout(new GridLayout(1, 2));
		P_Temp.add(new Label("Da quattro:"));
		P_Temp.add(T_BdaQuattro);
		optPanel.add(P_Temp);

		P_Temp = new Panel();
		P_Temp.setBackground( BackColor );
		P_Temp.setLayout(new GridLayout(1, 2));
		P_Temp.add(new Label("Da tre:"));
		P_Temp.add(T_BdaTre);
		optPanel.add(P_Temp);

		P_Temp = new Panel();
		P_Temp.setBackground( BackColor );
		P_Temp.setLayout(new GridLayout(1, 2));
		P_Temp.add(new Label("Da due:"));
		P_Temp.add(T_BdaDue);
		optPanel.add(P_Temp);

		P_Temp = new Panel();
		P_Temp.setBackground( BackColor );
		P_Temp.setLayout(new GridLayout(1, 2));
		P_Temp.add(new Label("Da uno:"));
		P_Temp.add(T_BdaUno);
		optPanel.add(P_Temp);

		return optPanel;
	}

	private Panel creaMainPanel(){ 	//crea il pannello di gioco ma restituisce solo la sua parte interna
		Panel mpanel = new Panel();	//Il pannello stesso
		Panel InsidePanel = new Panel();

		mpanel.setBackground( BackColor );
		mpanel.setLayout(new BorderLayout());

		InsidePanel.setBackground( BackColor );
		InsidePanel.setLayout(new GridLayout(1, 2));

		mpanel.add(new Label("Campo di Gara", 1), "North");
		mpanel.add(InsidePanel, "Center");

		output.setFont(new Font("Arial", Font.BOLD, 16));
		mpanel.add(output,"South");

		add(mpanel,"Center");

		return InsidePanel;
	}

	private void azzeraLabels(int x){				//Ripredispone le variabili ad ogni Inizio Partita
		BarcheCom		= new boolean[x+2][x+2];	//le posizioni delle barche del computer
		CasellaUt		= new casella[x+2][x+2];	//la scacchiera dell'utente
		CasellaUtAtt	= new casella[x+2][x+2];	//la scacchiera di attacco dell'utente
		hoColpitoInPrecedenza[0]=-1;				//Le caselle gi colpite
		hoColpitoInPrecedenza[1]=-1;				//Le caselle gi colpite

		for (int i=0; i<=x+1; i++) 				//Il Ciclo Inizializza le variabili
			for (int p=0; p<=x+1; p++){
				CasellaUt[i][p] = new casella(i,p,false);
				CasellaUtAtt[i][p] = new casella(i,p,true);
				CasellaUt[i][p].addMouseListener(this );
				CasellaUtAtt[i][p].addMouseListener(this );

				BarcheCom[i][p]=false;		//le posizioni delle barche del computer
				}

	}

	private Panel casellaUtAtt(int x){
		//Costruisce il pannello con le caselle di attacco dell'utente
		Panel s = new Panel();
		s.setBackground( new Color(0, 0, 250) );
		s.setLayout(new GridLayout(x + 1, x + 1, 1, 1));

		for (int p=0; p<=x; p++){ //creazione prima riga
			if (p==0) s.add( new Label("") );
			else s.add(new Label("" + lettera(p), 1) );
		}

		for (int i=1; i<=x; i++) //creazione altre righe
			for (int p=0; p<=x; p++){
					if (p==0) s.add(new Label("" + i, 1) );//creazione prima colonna
					else s.add(CasellaUtAtt[i][p]);
					}
		return s;
	}

	private Panel casellaUt(int x){
		//Costruisce il pannello con le caselle di difesa dell'utente
		Panel s = new Panel();
		s.setBackground( new Color(0, 0, 250) );
		s.setLayout(new GridLayout(x + 1, x + 1, 1, 1) );

		for (int p=0; p<=x; p++) //creazione prima riga
			if (p==0) s.add(new Label("", 1) );
			else s.add(new Label("" + lettera(p),1) );


		for (int i=1; i<=x; i++) //creazione altre righe
			for (int p=0; p<=x; p++){
					if (p==0) s.add(new Label("" + i, 1) );//creazione prima colonna
					else s.add(CasellaUt[i][p]);
					}
		return s;
	}

	public void NuovaPartita(){
		if (possoCliccare==true) return;	//Lo stato corrente non permette l'operazione
		//Acquisisce i dati necessari dal menu di Opzione e prepara il terreno di gioco
		try{
			//Acquisizione dati Dall'utente; potrebbero causare eccezioni
			MaxRighe = (new Integer(MaxRigheStr.getText())).intValue();
			BdaUno = (new Integer(T_BdaUno.getText())).intValue();
			BdaDue = (new Integer(T_BdaDue.getText())).intValue();
			BdaTre = (new Integer(T_BdaTre.getText())).intValue();
			BdaQuattro = (new Integer(T_BdaQuattro.getText())).intValue();
			//fine acquisizione

			azzeraLabels(MaxRighe);
			mainPanel.removeAll();
			Panel f = new Panel();
			f.setBackground(BackColor);
			f.setLayout(new BorderLayout());
			f.add(new Label("Le tue Barche",1), "North");
			f.add(casellaUt(MaxRighe), "Center");
			mainPanel.add(f);

			Panel g = new Panel();
			g.setBackground(BackColor);
			g.setLayout(new BorderLayout());
			g.add(new Label("Le Mie Barche",1), "North");
			g.add(casellaUtAtt(MaxRighe), "Center");
			mainPanel.add(g);

			validate();

			possoCliccare = true;
			output.setText("Posiziona le tue Barche cliccando sulle caselle!");
			Cm_Start.setLabel("Comincia!");

		}catch(Exception e){
			System.err.println("Eccezione in NuovaPartita " + e);
			output.setText("Errore! Controlla le opzioni scelte!");

		}

	}


	public void preparaBarcheUtente(int riga, int colonna){
		//viene chiamata quando l'utente deve posizionare le sue barche
		if ( CasellaUt[riga][colonna].isBoat() )	//se c' la barca nella casella...
			CasellaUt[riga][colonna].remBoat();		//la toglie altrimenti...
		else CasellaUt[riga][colonna].setBoat();	//la mette
	}


	private void attaccoUtente(int riga, int colonna){
		//viene chiamata quando l'utente clicca una casella per attaccare
		if ( !CasellaUtAtt[riga][colonna].isShot() ){ //Ignora se l'utente ha gi giocata
			if ( BarcheCom[riga][colonna] ){				//se c' la barca...
				CasellaUtAtt[riga][colonna].setBoat();		//..la disegna
				CasellaUtAtt[riga][colonna].shoot();		//..la indica come colpita
				if (CheckColpitoAffondataCom(riga,colonna))	//..se la barca  affondata
					output.setText("Affondata con " + riga + ", " + lettera(colonna) + "...Ti mancano " + (--DaColpireUt) + " !");
				else output.setText("Mi hai Colpito in " + riga + ", " + lettera(colonna) );
				if ( DaColpireUt==0 ) vittoria(true);	//ha vinto l'utente
				else turnoCom();						//Concede il turno al computer
			}//fine if colpita
			else{	//se non ha colpito una barca
				CasellaUtAtt[riga][colonna].shoot();	//la disegna come "Buco Nell'acqua"
				output.setText("Buco nell'acqua in " + riga + ", " + lettera(colonna));
				turnoCom();								//Concede il turno al computer
			}//fine else Non colpita
		}
	}

	private void attaccoCom(int riga, int colonna){
		//viene chiamata da turnoCom() con le coordinate da colpire
		if (CasellaUt[riga][colonna].shoot()){					//se la colpisco
			if (CheckColpitoAffondataUt(riga,colonna)){			//se l'intera barca  affondata
				output.setText(output.getText() + " Io ho affondato con " + riga + ", " + lettera(colonna) + "...Mi mancano " + (--DaColpireCom) + " !");
				if (Opzione[2].getState()) Circonda(riga,colonna); //se  il 2 livello circonda la barca per non ricolpire le caselle vicine
				hoColpitoInPrecedenza[0] = -1; hoColpitoInPrecedenza[1] = -1;	//imposta l'array con i valori di default
				if (DaColpireCom==0) vittoria(false); //ho vinto io
				else turnoUt();
			}//fine se  affondata
			else{hoColpitoInPrecedenza[0] = riga; hoColpitoInPrecedenza[1] = colonna;	//imposta l'array con i dati della casella colpita
				output.setText(output.getText() + "Ho colpito in " + riga + ", " + lettera(colonna)); turnoUt();
			}//fine else se non  affondata
		}// fine se la colpisco
		else{ //se non la colpisco
			output.setText(output.getText() + " Ho Tentato in " + riga + ", " + lettera(colonna) );
			turnoUt();			//concede il turno all'utente
		}//else
	}

	private void turnoCom(){		//E' il turno del computer!
		turno = false;				//fa si che l'utente non possa cliccare sul campo di gara
		int riga; int colonna; boolean ok=false;

		if ( (Opzione[1].getState() || Opzione[2].getState()) && hoColpitoInPrecedenza[0]!=-1 ){
			//Questo blocco all'interno dell If viene fatto solo se ha scelto il livello 2 o 3
			//e se era stata colpita un pezzo di barca in precedenza
			int[] a = ProssimaCasella(); //chiede di calcolare la prossima casella
			attaccoCom(a[0],a[1]); //prova a colpirla
		}//fine: se ha scelto pi del livello 1 e se si ha colpito in precedenza
		else{//oppure
			while(!ok){//finch non ho trovato una che non  stata gi provata
				riga	=random();		//valore casuale
				colonna	=random();		//valore casuale
				if ( !CasellaUt[riga][colonna].isShot() ){	//se non l'ho gi giocata...
					attaccoCom(riga,colonna);				//... provo a colpirla
					ok=true;								//serve per uscire dal ciclo
				}
			}//fine While Esce quando trova una casella da poter colpire
		}//fine else Non avevo preso niente prima o livello 1
	}

	private void turnoUt(){		//E' il turno dell'utente, devo solo aspettare che lui clicchi!
		turno = true;			//Gli do la possibilit di cliccare
		output.setText( output.getText() + " Tocca a Te.");
	}

	private void InizioGara(){	//Inizia la gara
		gara  = true;
		DaColpireUt 	= BdaUno + BdaDue + BdaTre + BdaQuattro; //Imposta le barche ancora da colpire
		DaColpireCom 	= BdaUno + BdaDue + BdaTre + BdaQuattro; //Imposta le barche ancora da colpire
		Cm_Start.setLabel("Smetti di Giocare");
		turnoUt();			//Concede il primo turno all'utente
	}

	private int richiestaInizio(){	//Viene chiamata quando l'utente ha posizionato le sue barche.
		//Restituisce i seguenti valori
		//1 = Ok; 2 = errore nel posizionamento delle barche; 3 = errato numero di barche
		int x=0;
		try{ 	//Conta le barche

			int numeroBarche[] = {0,0,0,0}; //mi segno quante barche ci sono di ogni tipo

			for (int i=1; i<=MaxRighe; i++)
				for (int p=1; p<=MaxRighe; p++){
					if ( (x = barca(i,p)) == -1 ) return 2;
					if (x>0) numeroBarche[x-1] = numeroBarche[x-1] +1;
					}//fine for

			//controllo numero barche
			if (numeroBarche[0] != 1 * BdaUno) return 3;
			if (numeroBarche[1] != 2 * BdaDue) return 3;
			if (numeroBarche[2] != 3 * BdaTre) return 3;
			if (numeroBarche[3] != 4 * BdaQuattro) return 3;


			return 1;

		}catch(Exception e){
			System.err.println("Errore in RichiestaInizio! " + x);
			return 3;	//Errore. Non da la possibilita di iniziare
		}
	}

////////////////////////// Per l'utente ////////////
	private boolean CheckColpitoAffondataUt(int riga, int colonna){
		//vede se  affondata una barca dell'utente
		if ( !CheckColpitoAffondataUt(riga, colonna+1, 0) ) return false;
		if ( !CheckColpitoAffondataUt(riga+1,colonna,1) ) return false;
		if ( !CheckColpitoAffondataUt(riga-1,colonna,2) ) return false;
		if ( !CheckColpitoAffondataUt(riga,colonna-1,3) ) return false;

		//Se ho colpito tutte (cio nessuna di sopra ha dato false le imposto Affondate
		Affonda(riga, colonna, 0); //questo affonda anche la presente
		Affonda(riga+1, colonna, 1);
		Affonda(riga-1, colonna, 2);
		Affonda(riga, colonna-1, 3);
		validate();
		return true;
	}

	private boolean CheckColpitoAffondataUt(int riga, int colonna, int verso){
		//restituisce false se c' una barca non colpita
		if ( !CasellaUt[riga][colonna].isBoat() ) return true; //se non c' la barca

		if ( !CasellaUt[riga][colonna].isShot() ) return false; //se c' la barca ma non  colpita
		switch( verso ){
			case 0: return CheckColpitoAffondataUt(riga,colonna+1,verso);
			case 1: return CheckColpitoAffondataUt(riga+1,colonna,verso);
			case 2: return CheckColpitoAffondataUt(riga-1,colonna,verso);
			case 3: return CheckColpitoAffondataUt(riga,colonna-1,verso);
		}
		//non devo passarci!
		System.err.println("Il programma non doveva passare per questo punto!!\nContattare l'autore!\nErrore in int CheckColpitoAffondataUt(int riga, int colonna, int verso)");
		return false;
	}

	private void Affonda(int riga, int colonna, int verso){
		//Disegna le barche affondate nel verso indicato
		if ( CasellaUt[riga][colonna].isBoat() ){//se c' la barca
			CasellaUt[riga][colonna].setKilled();
			switch( verso ){
				case 0: {Affonda(riga,colonna+1,verso); break;}
				case 1: {Affonda(riga+1,colonna,verso); break;}
				case 2: {Affonda(riga-1,colonna,verso); break;}
				case 3: {Affonda(riga,colonna-1,verso); break;}
			}
		}//fine if
	}

	private boolean checkAdiacenti(int riga, int colonna, int[] array){
		//Conta quante barche adiacenti ci sono a quella indicata
		//Ovviamente ce ne possono essere al massimo due e sulla stessa riga o colonna
		//altrimenti significa che si forma una barca d'angolo fuori regolamento
		int conta = 0;
		if (CasellaUt[riga-1][colonna].isBoat() ) { aggiungi(riga-1, colonna, array, ++conta); };
		if (CasellaUt[riga+1][colonna].isBoat() )  { aggiungi(riga+1, colonna, array, ++conta); };
		if (CasellaUt[riga][colonna-1].isBoat() )  { aggiungi(riga, colonna-1, array, ++conta); };
		if (CasellaUt[riga][colonna+1].isBoat() )  { aggiungi(riga, colonna+1, array, ++conta); };
		if (CasellaUt[riga-1][colonna-1].isBoat() ) return false; //non possono esseri barche sugli angoli
		if (CasellaUt[riga-1][colonna+1].isBoat() ) return false;
		if (CasellaUt[riga+1][colonna-1].isBoat() ) return false;
		if (CasellaUt[riga+1][colonna+1].isBoat() ) return false;

		if (conta>2) return false;
		if (conta==2)
			if ( (array[0]!=array[2]) && (array[1]!=array[3]) )
				return false; //significa che una  sulla stessa riga e l'altra sulla stessa colonna

		return true;

	}

	private void aggiungi (int riga, int colonna, int[] array, int conta){
		//Utilizzata dalla procedura sopra
		int p=0;
		if (conta>1) p = p + 2;
		array[0 + p]=riga; array[1 + p]=colonna;
	}

	private int barca(int riga, int colonna){
		//Controlla quanto  lunga la barca che ha un pezzo in riga, colonna
		if ( !CasellaUt[riga][colonna].isBoat() ) return 0; //nave da 0, cio nessuna barca
		int array[] = {-1,-1,-1,-1};

		if ( !checkAdiacenti(riga, colonna, array) ) return -1; //errore
		int x = 1 + barca(riga, colonna+1, 0) + barca(riga+1,colonna,1) + barca(riga-1,colonna,2) + barca(riga,colonna-1,3);
		return x;
	}

	private int barca(int riga, int colonna, int verso){
		//Usata da quella sopra
		if ( !CasellaUt[riga][colonna].isBoat() ) return 0; //nave da 0, cio nessuna barca

		switch( verso ){
			case 0: return 1 + barca(riga,colonna+1,verso);
			case 1: return 1 + barca(riga+1,colonna,verso);
			case 2: return 1 + barca(riga-1,colonna,verso);
			case 3: return 1 + barca(riga,colonna-1,verso);
		}
		//non devo passarci!
		System.err.println("Il programma non doveva passare per questo punto!!\nContattare l'autore!\nErrore in int barca(int riga, int colonna, int verso)");
		return 0;
	}

	public void segnaCaselleLateraliUt(){
		//Segna le caselle fuori dal campo di gioco
		for (int i=0; i<MaxRighe+2; i++){
			CasellaUt[0][i].setShot(); //le caselle della prima riga
			CasellaUt[MaxRighe+1][i].setShot(); //le caselle dell'ultima riga
			CasellaUt[i][0].setShot(); //le caselle della prima colonna
			CasellaUt[i][MaxRighe+1].setShot(); //le caselle dell'ultima colonna
			}
	}



	private void Circonda(int riga, int colonna){
		//Circonda la barca che ha un punto in riga, colonna. Usato nel livello 3
		CasellaUt[riga-1][colonna].setShot();
		CasellaUt[riga+1][colonna].setShot();
		CasellaUt[riga][colonna-1].setShot();
		CasellaUt[riga][colonna+1].setShot();
		CasellaUt[riga-1][colonna-1].setShot();
		CasellaUt[riga-1][colonna+1].setShot();
		CasellaUt[riga+1][colonna-1].setShot();
		CasellaUt[riga+1][colonna+1].setShot();

		Circonda(riga,colonna+1, 0);
		Circonda(riga+1,colonna, 1);
		Circonda(riga,colonna-1, 2);
		Circonda(riga-1,colonna, 3);
	}


	private void Circonda(int riga, int colonna, int verso){
		//Usata dalla procedura sopra
		if ( CasellaUt[riga][colonna].isBoat() ){ //se c' una barca continuo, senn non faccio niente
			CasellaUt[riga-1][colonna].setShot();
			CasellaUt[riga+1][colonna].setShot();
			CasellaUt[riga][colonna-1].setShot();
			CasellaUt[riga][colonna+1].setShot();
			CasellaUt[riga-1][colonna-1].setShot();
			CasellaUt[riga-1][colonna+1].setShot();
			CasellaUt[riga+1][colonna-1].setShot();
			CasellaUt[riga+1][colonna+1].setShot();
			switch( verso ){
				case 0: {Circonda(riga,colonna+1,verso); break;}
				case 1: {Circonda(riga+1,colonna,verso); break;}
				case 2: {Circonda(riga,colonna-1,verso); break;}
				case 3: {Circonda(riga-1,colonna,verso); break;}
			}
		}//fine if
	}

///////////////////////// Per il computer ///////////////////

	private boolean CheckColpitoAffondataCom(int riga, int colonna){//vede se  affondata
		//Controlla se  stata affondata una barca del computer
		if ( !CheckColpitoAffondataCom(riga, colonna+1, 0) ) return false;
		if ( !CheckColpitoAffondataCom(riga+1,colonna,1) ) return false;
		if ( !CheckColpitoAffondataCom(riga-1,colonna,2) ) return false;
		if ( !CheckColpitoAffondataCom(riga,colonna-1,3) ) return false;

		//Se ho colpito tutte (cio nessuna di sopra ha dato false) le imposto Affondate
		AffondaCom(riga, colonna, 0); //questa affonda anche questa
		AffondaCom(riga+1, colonna, 1);
		AffondaCom(riga-1, colonna, 2);
		AffondaCom(riga, colonna-1, 3);
		return true;
	}

	private boolean CheckColpitoAffondataCom(int riga, int colonna, int verso){
		//restituisce false se c' una barca non colpita
		if ( !BarcheCom[riga][colonna] ) return true; //se non c' la barca

		if ( !CasellaUtAtt[riga][colonna].isShot() ) return false; //se c' la barca ma non  colpita
		switch( verso ){
			case 0: return CheckColpitoAffondataCom(riga,colonna+1,verso);
			case 1: return CheckColpitoAffondataCom(riga+1,colonna,verso);
			case 2: return CheckColpitoAffondataCom(riga-1,colonna,verso);
			case 3: return CheckColpitoAffondataCom(riga,colonna-1,verso);
		}
		//non devo passarci!
		System.err.println("Il programma non doveva passare per questo punto!!\nContattare l'autore!\nErrore in int CheckColpitoAffondataUt(int riga, int colonna, int verso)");
		return false;
	}

	private void AffondaCom(int riga, int colonna, int verso){
		//Imposta affondate tutti i pezzi di una barca del computer
		if ( CasellaUtAtt[riga][colonna].isBoat() ){//se c' la barca
			CasellaUtAtt[riga][colonna].setKilled();

			switch( verso ){
				case 0: {AffondaCom(riga,colonna+1,verso); break;}
				case 1: {AffondaCom(riga+1,colonna,verso); break;}
				case 2: {AffondaCom(riga-1,colonna,verso); break;}
				case 3: {AffondaCom(riga,colonna-1,verso); break;}
			}
		}//fine if
	}


	private boolean checkAdiacentiCom1(int riga, int colonna){
		//Controlla se c' una barca adiacente alle coordinate richieste
		if (BarcheCom[riga][colonna]) return true; //controlla anche la stessa
		if (BarcheCom[riga-1][colonna]) return true;
		if (BarcheCom[riga+1][colonna]) return true;
		if (BarcheCom[riga][colonna-1]) return true;
		if (BarcheCom[riga][colonna+1]) return true;
		if (BarcheCom[riga-1][colonna-1]) return true; //non possono esseri barche sugli angoli
		if (BarcheCom[riga-1][colonna+1]) return true;
		if (BarcheCom[riga+1][colonna-1] ) return true;
		if (BarcheCom[riga+1][colonna+1] ) return true;

		return false;

	}

	private boolean checkAdiacentiCom(int riga, int colonna, int[] array){
		//Vede e immette sull'array se ci sono barche sopra o sotto alla cella assegnata
		int conta = 0;
		if ( CasellaUt[riga-1][colonna].isShot() && CasellaUt[riga-1][colonna].isBoat() ) { aggiungi(riga-1, colonna, array, ++conta); };
		if ( CasellaUt[riga+1][colonna].isShot() && CasellaUt[riga+1][colonna].isBoat() ) { aggiungi(riga+1, colonna, array, ++conta); };
		if ( CasellaUt[riga][colonna-1].isShot() && CasellaUt[riga][colonna-1].isBoat() ) { aggiungi(riga, colonna-1, array, ++conta); };
		if ( CasellaUt[riga][colonna+1].isShot() && CasellaUt[riga][colonna+1].isBoat() ) { aggiungi(riga, colonna+1, array, ++conta); };

		if (conta==0) return false; //se non ci sono barche gi colpite vicino

		return true;

	}


	private int[] ProssimaCasella(){
		//questa funzione utilizza l'array hoColpitoInPrecedenza[] per inserire la prossima
		//casella da colpire. Utilizzato nel livello 2
		//Ipotesi: la casella (hoColpitoInPrecedenza[0],hoColpitoInPrecedenza[1]) ha una barca colpita
		//Alla fine restituisce riga, colonna da colpire

		int[] daRestituire = {-1,-1}; //sono quelle da restituire
		int array[] = {-1,-1,-1,-1};
		if ( !checkAdiacentiCom(hoColpitoInPrecedenza[0],hoColpitoInPrecedenza[1], array ) ){ //se era la prima che ho colpito
			if ( !CasellaUt[hoColpitoInPrecedenza[0]-1][hoColpitoInPrecedenza[1]].isShot() )
				{daRestituire[0]=hoColpitoInPrecedenza[0]-1; daRestituire[1]=hoColpitoInPrecedenza[1]; return daRestituire;};
			if ( !CasellaUt[hoColpitoInPrecedenza[0]][hoColpitoInPrecedenza[1]+1].isShot() )
				{daRestituire[0]=hoColpitoInPrecedenza[0]; daRestituire[1]=hoColpitoInPrecedenza[1]+1; return daRestituire;};
			if ( !CasellaUt[hoColpitoInPrecedenza[0]+1][hoColpitoInPrecedenza[1]].isShot() )
				{daRestituire[0]=hoColpitoInPrecedenza[0]+1; daRestituire[1]=hoColpitoInPrecedenza[1]; return daRestituire;};
			daRestituire[0]=hoColpitoInPrecedenza[0]; daRestituire[1]=hoColpitoInPrecedenza[1]-1; return daRestituire;
		}//se non aveva colpito nulla
		else{
			if (array[0]==hoColpitoInPrecedenza[0]){//se era sulla stessa riga
				if ( possoColpire(hoColpitoInPrecedenza[0],hoColpitoInPrecedenza[1]+1,daRestituire,0) ) return daRestituire; //se posso colpire a destra (riga e colonna danno il valore)
				else {boolean c = possoColpire(hoColpitoInPrecedenza[0],hoColpitoInPrecedenza[1]-1,daRestituire,2); return daRestituire; } //se posso colpire a sinistra (riga e colonna danno il valore)
			}//se era sulla stessa riga

			else{//se era sulla stessa colonna
				if ( possoColpire(hoColpitoInPrecedenza[0]+1,hoColpitoInPrecedenza[1],daRestituire,1) ) return daRestituire; //se posso colpire in basso (riga e colonna danno il valore)
				else {boolean c = possoColpire(hoColpitoInPrecedenza[0]-1,hoColpitoInPrecedenza[1],daRestituire,3); return daRestituire; } //se posso colpire in alto (riga e colonna danno il valore)
			}//se era sulla stessa colonna
		}//se l'avevo colpito
	}

	private boolean possoColpire(int riga, int colonna,int[] daRestituire, int verso){
		//restituisce false se non c' una casella da colpire nel verso indicato

		if ( !CasellaUt[riga][colonna].isShot() ){ //se non  stata gi giocata inserisco le coordinate e restituisco true
			daRestituire[0]=riga; daRestituire[1]=colonna; return true;
		}
		if ( CasellaUt[riga][colonna].isShot() && !CasellaUt[riga][colonna].isBoat() ) return false; // non posso andare di qua perch ho gi fatto un buco nell'acqua

		switch( verso ){
			case 0: return possoColpire(riga,colonna+1,daRestituire,verso);
			case 1: return possoColpire(riga+1,colonna,daRestituire,verso);
			case 2: return possoColpire(riga,colonna-1,daRestituire,verso);
			case 3: return possoColpire(riga-1,colonna,daRestituire,verso);
		}
		System.err.println("Non devo passare da possoColpire(int,int,int,int)! Contattare l'autore!");
		return false;
	}
////////////////////////FINE Controlli di caselle varie


	public void VoglioSmettere(){
		//Viene chiamata quando l'utente vuole smettere o quando finisce una partita
		if (!gara) return;	//Lo stato corrente non permette l'operazione
		gara = false;
		possoCliccare = false;
		output.setText(output.getText() + " Per ricominciare seleziona Inizio Partita.");
		showBarcheCom(); //fa vedere dove erano le barche del computer
		Cm_Start.setLabel("Nuova Partita");
		validate();
	}

	private void vittoria(boolean utente){	//Imposta i messaggi di vittoria
		if (utente) output.setText("BRAVISSIMO HAI VINTO!");
		else output.setText("Mi Dispiace, HO VINTO IO, Ritenta!");
		VoglioSmettere();
	}

	private void preparaMieNavi(){
		//Questa procedura serve per impostare le posizioni delle navi del computer
		//Si estrae una coordinata e un verso (alto-basso o destra-sinistra) e si vede se
		//c' lo spazio in quella posizione per inserire una barca di lunghezza w
		//Si ripete il procedimento per k barche decise dall'utente nelle opzioni
		int riga; int colonna;
		boolean verso;
		int mancano;
		int i; int j;

		for (int w=4; w>0; w--){						//w mi dice quanto  lunga la barca
		int k=0; //ma deve essere reinizializzato!		//k rappresenta il numero di barche da creare per ogni lunghezza

		//dico quante ne voglio
		if (w==4) k=BdaQuattro;
		if (w==3) k=BdaTre;
		if (w==2) k=BdaDue;
		if (w==1) k=BdaUno;


		while(k>0){
			riga 	= random();		//Casuale
			colonna = random();		//Casuale
			if ( !checkAdiacentiCom1(riga,colonna) ){ //Se non ci sono gi barche adiacenti
				verso=num.nextBoolean();				//Estrae un verso
				if (verso){					//Destra sinistra
					mancano=MaxRighe-colonna;		//Calcola lo spazio fino al bordo destro
					if (mancano >= w-1){	i = colonna; j = colonna + w-1;}		//Se  poco sposta la barca... e calcola la colonna di inizio e di fine
					else {	i = colonna - w + 1 + mancano; j = mancano + colonna;} 	//Se va bene calcola la colonna di inizio e di fine
					if (puoBarcaRiga(i,j,riga) ){//se si puo infilare
						for (int p=i; p<=j; p++) BarcheCom[riga][p] = true;
						k--; //una barca l'ho fatta!
						}
					}//fine if
				else{						//Alto-Basso
					mancano=MaxRighe-riga;			//Calcola lo spazio fino al bordo destro
					if (mancano >= w-1){i = riga; j = riga + w - 1;}			//Se  poco sposta la barca... e calcola la colonna di inizio e di fine
					else {	i = riga - w + 1 + mancano; j = mancano + riga;} 	//Se va bene calcola la colonna di inizio e di fine
					if (puoBarcaCol(i,j,colonna) ){//se si puo infilare
						for (int p=i; p<=j; p++) BarcheCom[p][colonna] = true;
						k--; //una barca l'ho fatta!
						}
					}//fine else

			}//fine if

		}//fine While(k) di creazione di un tipo di barca

		}//fine For di creazione delle barche

		output.setText("Ho impostato le mie barche! Siamo Pronti.");
	}

	private boolean puoBarcaRiga(int da, int a, int riga){
		//Controlla che la barca possa stare in una riga con colonna che comincia da 'da' a 'a'
		for (int p=da; p<=a; p++)
			if ( checkAdiacentiCom1(riga, p) ) return false;
		return true;
	}

	private boolean puoBarcaCol(int da, int a, int col){
		//Controlla che la barca possa stare in una colonna con riga che comincia da 'da' a 'a'
		for (int p=da; p<=a; p++)
			if ( checkAdiacentiCom1(p, col) ) return false;
		return true;
	}

	private char lettera(int c){	//Trasforma la colonna numero 'c' nella lettera corrispondente
		return (char) ('A' + (c - 1));
	}

	private int random(){ //restituisce un numero casuale compreso fra 1 e MaxRighe
		return num.nextInt(MaxRighe) +1;
	}

	private void showBarcheCom(){ //Visualizza le barche del computer alla fine del gioco
		try{
			Panel s = new Panel();
			casella t;
			s.setBackground( new Color(0, 0, 250) );
			s.setLayout(new GridLayout(MaxRighe + 1, MaxRighe + 1, 1, 1));

			for (int p=0; p<=MaxRighe; p++){ //creazione prima riga
				if (p==0) s.add( new Label("") );
				else s.add(new Label("" + lettera(p), 1) );
			}

			for (int i=1; i<=MaxRighe; i++) //creazione altre righe
				for (int p=0; p<=MaxRighe; p++){
						if (p==0) s.add(new Label("" + i, 1) );//creazione prima colonna
						else{
							s.add(t=new casella(i,p,false));
							if (BarcheCom[i][p]) t.setBoat();
							}
						}
			Frame a = new frame(s);
		}catch(Exception e){
			System.err.println("Eccezione in showBarcheCom " + e);
			output.setText("Errore! E' possibile che sia finita la memoria!");

		}

	}


	/***
	* Il main serve per far partire il programma Stand Alone.<br>L'applet viene inserito in una finestra e viene inizializzato.<br>Non ha bisogno di argomenti.
	*/
	public static void main(String Args[]){
		java.applet.Applet a = new BattagliaNavale();
		frame w = new frame(a);
	}

}
