package BattagliaNavaleFromVb;

import SMom.IReceiver;
import SMom.CEnvelope;


/***
 * Funge da Server per i processi Vb.
 * Classe principale del progetto di Wrapping.
 * Ad ogni nuovo Client viene creata una classe Slave per gestirlo.
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
public class VbWrapper implements IReceiver{
	/**
	 * Porta di default per il server
	 */
	private static int mDEFAULTSERVERPORT=6450;
	/**
	 * Riferimento al Dispatcher
	 */
	private SMom.Dispatcher.IDispatcher mDispatcher;
	
	/**
	 * L'Object ID  costante, ovvero <B>VbWrapper</B>
	 */
	public String getObjectID() {
		return "VbWrapper";
	}
	
	/**
	 * Costruzione ed inzializzazione del server
	 */
	private VbWrapper(int ServerPort) throws Exception{
		//-------------------		SETUP	---------------------
		SMom.Dispatcher.CSinchronusAndSequentialDispatcher disp = new SMom.Dispatcher.CSinchronusAndSequentialDispatcher();
		SMom.MsgManager.CTcpManager manager = new SMom.MsgManager.CTcpManager(ServerPort);
		
		//Registro me stesso nel dispatcher di messaggi
		disp.Register(this);
		this.mDispatcher = disp;
		
		//Faccio partire il server
		manager.setDispatcher(disp);
		manager.StartListenforMessages();
	}
	
	/**
	 * Dovrebbero giungere messaggi di HELLO e BYE
	 * L'identificativo del sender deve comparire nella Envelope come Sender.
	 */
	public void msgArrived(CEnvelope parm1) {
		if (parm1.getMessage().equals("HELLO")){
			//Creo un nuovo gestore e lo memorizzo nel dispatcher
			mDispatcher.Register(
					new CommandFromVbListener(parm1.getSender().getObjectID()));
		}else if (parm1.getMessage().equals("BYE")){
			mDispatcher.UnRegister(parm1.getSender().getObjectID());
		}
		
	}
	
	public static void main(String[] args) {
		int PortaDiAscolto=mDEFAULTSERVERPORT;
		/**
		 *	Vengono creati un manager TCP ed un Dispatcher
		 *  Successivamente vengono gestiti i comandi ricevuti da un Sendere Vb
		 *	E' possibile indicare attraverso gli argomenti del main la porta di ascolto
		 */
		//-----------------		PARAMETRI DI INGRESSO	---------
		if (args.length>0){
			if (args[0].equals("?")){
				System.out.println("VbWrapper. Uso: java VbWrapper <ServerPort>");
				System.exit(0);
			}else{
				try{
					PortaDiAscolto = Integer.parseInt(args[0]);
				}catch(Exception e){
					System.out.println("Cannot decode <ServerPort> " + args[0] + 
						" due to exception: " + e.toString());
				}
			}
		}
		
		// Creo il server
		try{
			new VbWrapper(PortaDiAscolto);
		}catch(Exception e){
			System.out.println("Error initializing. VbWrapper dies." + e.toString());
			e.printStackTrace(System.out);
			System.exit(-1);
		}	
	}	
}

/**
 * Classe utile per ricevere i comandi da Visual Basic.
 * @version 	 0.1 - Settembre 2004
 * @author 		 <b>Giorgio Bernardi</b>.<br/>E-Mail: <A HREF="mailto:giorgio.bernardi@studio.unibo.it">Giorgio.Bernardi@studio.unibo.it</A>
 */
class CommandFromVbListener implements IReceiver{
	
	/**
	 * Riferimento alla battaglia navale gestita da questo ricevitore
	 */
	private NavalBattle.BattagliaNavale mBattaglia;
	
	/**
	 *	Riferimento alla finestra che contiene la battaglia navale
	 */
	private NavalBattle.frame			mFrame;
	
	/**
	 * Nome del pari visual basic
	 */
	private String mstrPeerID;
	
	/**
	 * Costruttore al quale viene indicato l'ID del pari Visual Basic
	 */
	public CommandFromVbListener(String PeerID){
		mstrPeerID=PeerID;
	}
	
	/**
	 * Verifica l'esistenza della battaglia navale, ed eventualmente la crea
	 */
	private void checkCreate(){
		if (mBattaglia == null){
			System.out.println("Creo una nuova Battaglia Navale");
			mBattaglia = new NavalBattle.BattagliaNavale();
			mFrame = new NavalBattle.frame(mBattaglia,false);
		}
	}
	
	/**
	 * L'Object ID  costante, ovvero <B>CommandFromVbListener</B>
	 */
	public String getObjectID() {
		return mstrPeerID + "VbWrapper";
	}
	
	/**
	 * Esistono diversi tipi di messaggi che possono giungere.
	 * Il metodo gestisce i messaggi inoltrando eventualmente le chiamate all' oggetto BattagliaNavale
	 */
	public void msgArrived(CEnvelope parm1) {
		//------------ CREAZIONE IN CASO DI NECESSITA	-
		checkCreate();
		//------------	GESTIONE MESSAGGI	------------
		if (parm1.getMessage().equals("NEW_GAME"))
			mBattaglia.NuovaPartita();
		else if (parm1.getMessage().equals("SHOW_ISTRUCTIONS"))
			mBattaglia.ShowIstruzioni();
		else if (parm1.getMessage().equals("BYE")){
			mFrame.hide();
			mFrame.dispose();
			mBattaglia.stop();
			mBattaglia.destroy();
			mBattaglia = null;
			mFrame=null;
		}
	}
}