/*
 * Decompiled with CFR 0.152.
 */
package SMom.ObjectOriented;

import SMom.CEnvelope;
import SMom.Exceptions.CCannotConvertEnvelopeToCProcedureException;
import SMom.ISender;
import SMom.ObjectOriented.CFunctionResult;
import SMom.ObjectOriented.Values.CInt32Value;
import SMom.ObjectOriented.Values.CStringValue;
import SMom.ObjectOriented.Values.CValue;
import SMom.SMomUtilities;
import java.util.Vector;

public class CProcedure {
    private String mstrName;
    private String mstrInstanceID = "CProcedure|" + SMomUtilities.getUniqueIdentifier();
    private Vector mParams = new Vector();
    protected static String CharDelimiter = ":";

    public CProcedure() {
    }

    public CProcedure(String string) {
        this();
        this.setName(string);
    }

    public CProcedure(CEnvelope cEnvelope) throws CCannotConvertEnvelopeToCProcedureException {
        this();
        if (!this.fromEnvelope(cEnvelope)) {
            throw new CCannotConvertEnvelopeToCProcedureException("SMom.CProcedure", cEnvelope.getMessage());
        }
    }

    public void AddParam(CValue cValue) {
        this.mParams.addElement(cValue);
    }

    public CValue GetParam(int n) {
        if (this.GetParamsCount() >= n && n > 0) {
            return (CValue)this.mParams.elementAt(n - 1);
        }
        return null;
    }

    public int GetParamsCount() {
        return this.mParams.size();
    }

    public Class[] GetParamsClass() {
        if (this.GetParamsCount() > 0) {
            Class[] classArray = new Class[this.GetParamsCount()];
            int n = 1;
            while (n <= this.GetParamsCount()) {
                classArray[n - 1] = this.GetParam(n).getJavaClass();
                ++n;
            }
            return classArray;
        }
        return null;
    }

    public Object[] GetParams() {
        if (this.GetParamsCount() > 0) {
            Object[] objectArray = new Object[this.GetParamsCount()];
            int n = 1;
            while (n <= this.GetParamsCount()) {
                Object object;
                objectArray[n - 1] = object = this.GetParam(n).toJavaObject();
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    public void setName(String string) {
        this.mstrName = string;
    }

    public String getName() {
        return this.mstrName;
    }

    public String getInstanceID() {
        return this.mstrInstanceID;
    }

    protected void setInstanceID(String string) {
        this.mstrInstanceID = string;
    }

    public String toString() {
        String string = this.getName() + "(";
        int n = 1;
        while (n < this.GetParamsCount()) {
            if (n > 1) {
                string = string + ",";
            }
            string = string + this.GetParam(n).getActualValueToString();
            ++n;
        }
        return string + ")";
    }

    public CEnvelope toEnvelope(ISender iSender, String string) {
        String string2 = String.valueOf(this.getInstanceID().length()) + CharDelimiter + String.valueOf(this.getName().length()) + CharDelimiter + String.valueOf(this.GetParamsCount()) + CharDelimiter + this.getInstanceID() + this.getName();
        int n = 1;
        while (n <= this.GetParamsCount()) {
            string2 = string2 + this.GetParam(n).getType() + CharDelimiter + String.valueOf(this.GetParam(n).getActualValueToString().length()) + CharDelimiter + this.GetParam(n).getActualValueToString();
            ++n;
        }
        return new CEnvelope(iSender, string, string2);
    }

    protected boolean fromEnvelope(CEnvelope cEnvelope) {
        String[] stringArray = cEnvelope.getMessage().split(CharDelimiter, 4);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = stringArray[0].length() + stringArray[1].length() + stringArray[2].length() + CharDelimiter.length() * 3;
        this.setInstanceID(cEnvelope.getMessage().substring(n4, n4 + n));
        this.setName(cEnvelope.getMessage().substring(n4 + n, n4 + n + n2));
        String string = cEnvelope.getMessage().substring(n4 + n + n2);
        int n5 = 1;
        while (n5 <= n3) {
            CValue cValue = CProcedure.parseFromString(string);
            if (cValue != null) {
                this.AddParam(cValue);
                int n6 = cValue.getType().length() + cValue.getActualValueToString().length() + String.valueOf(cValue.getActualValueToString().length()).length() + 2;
                if (n5 < n3) {
                    string = string.substring(n6);
                }
            } else {
                return false;
            }
            ++n5;
        }
        return true;
    }

    protected static CValue parseFromString(String string) {
        String[] stringArray = string.split(CharDelimiter, 3);
        int n = stringArray[0].length() + stringArray[1].length() + CharDelimiter.length() * 2;
        CValue cValue = null;
        if (stringArray[0].equals("String")) {
            cValue = new CStringValue();
        } else if (stringArray[0].equals("Int32")) {
            cValue = new CInt32Value();
        } else {
            return null;
        }
        if (!((CValue)cValue).setActualValueFromString(string.substring(n, n + Integer.parseInt(stringArray[1])))) {
            return null;
        }
        return cValue;
    }

    public CFunctionResult getResponseMessage(boolean bl, CValue cValue) {
        return new CFunctionResult(this, bl, cValue);
    }
}

