/*
 * Decompiled with CFR 0.152.
 */
package SMom.ObjectOriented;

import SMom.CEnvelope;
import SMom.Exceptions.CCannotConvertEnvelopeToCFunctionResultException;
import SMom.ObjectOriented.CProcedure;
import SMom.ObjectOriented.Values.CValue;

public class CFunctionResult {
    public CValue FunctionResult;
    private boolean mblnResultIsValid;
    private String mstrInstanceID;
    private String mstrName;
    protected static String CharDelimiter = ":";

    public CFunctionResult(CProcedure cProcedure, boolean bl, CValue cValue) {
        this.setFunctionName(cProcedure.getName());
        this.setInstanceID(cProcedure.getInstanceID());
        this.setIsValid(bl);
        this.FunctionResult = cValue;
    }

    public CFunctionResult(CEnvelope cEnvelope) throws CCannotConvertEnvelopeToCFunctionResultException {
        if (!this.fromEnvelope(cEnvelope)) {
            throw new CCannotConvertEnvelopeToCFunctionResultException();
        }
    }

    public String getInstanceID() {
        return this.mstrInstanceID;
    }

    private void setInstanceID(String string) {
        this.mstrInstanceID = string;
    }

    public boolean IsValid() {
        return this.mblnResultIsValid && this.FunctionResult != null;
    }

    public void setIsValid(boolean bl) {
        this.mblnResultIsValid = bl;
    }

    private void setFunctionName(String string) {
        this.mstrName = string;
    }

    public String getFunctionName() {
        return this.mstrName;
    }

    public String toMsgEnvelope() {
        String string = String.valueOf(this.getInstanceID().length()) + CharDelimiter + String.valueOf(this.getFunctionName().length()) + CharDelimiter + this.getInstanceID() + this.getFunctionName();
        string = string + (this.IsValid() ? "1" : "0");
        if (this.FunctionResult != null) {
            string = string + this.FunctionResult.getType() + CharDelimiter + String.valueOf(this.FunctionResult.getActualValueToString().length()) + CharDelimiter + this.FunctionResult.getActualValueToString();
        }
        return string;
    }

    protected boolean fromEnvelope(CEnvelope cEnvelope) {
        String[] stringArray = cEnvelope.getMessage().split(CharDelimiter, 3);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = stringArray[0].length() + stringArray[1].length() + CharDelimiter.length() * 2;
        this.setInstanceID(cEnvelope.getMessage().substring(n3, n3 + n));
        this.setFunctionName(cEnvelope.getMessage().substring(n3 + n, n3 + n + n2));
        this.setIsValid(cEnvelope.getMessage().charAt(n3 + n + n2) == '1');
        try {
            String string = cEnvelope.getMessage().substring(n3 + n + n2 + 1);
            this.FunctionResult = CProcedure.parseFromString(string);
            if (this.FunctionResult == null) {
                return false;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return true;
    }
}

