/*
 * Decompiled with CFR 0.152.
 */
package SMom.ObjectOriented;

import SMom.CEnvelope;
import SMom.Dispatcher.IDispatcher;
import SMom.Exceptions.CCannotConvertEnvelopeToCFunctionResultException;
import SMom.Exceptions.CRemoteException;
import SMom.Exceptions.CTimeOutExpiredException;
import SMom.Exceptions.CUnKnownRemoteException;
import SMom.Exceptions.CUnKnownSMomException;
import SMom.IReceiver;
import SMom.ISender;
import SMom.ObjectOriented.CFunctionResult;
import SMom.ObjectOriented.CProcedure;
import SMom.ObjectOriented.Values.CValue;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;

public class CDynamicStub
implements ISender,
IReceiver {
    private IDispatcher mDispatcher;
    private String mstrRemoteMsgManagerAddress;
    private String mstrSkeletonObjectID;
    private HashMap Risultati;
    private String mstrObjectID;
    private long mintTimeOutSeconds = DEFAULT_TIMEOUT_MILLI_SECONDS;
    private static long DEFAULT_TIMEOUT_MILLI_SECONDS = 10000L;

    private CDynamicStub() {
        this.Risultati = new HashMap();
        this.setTimeOutMilliSeconds(DEFAULT_TIMEOUT_MILLI_SECONDS);
    }

    public CDynamicStub(IDispatcher iDispatcher, String string, String string2) {
        this();
        this.setDispatcher(iDispatcher);
        this.setRemoteMsgManagerAddress(string);
        this.setRemoteSkeletonID(string2);
    }

    public CDynamicStub(IDispatcher iDispatcher, String string, String string2, String string3) {
        this(iDispatcher, string, string2);
        this.setStubID(string3);
    }

    public String getRemoteSkeletonID() {
        return this.mstrSkeletonObjectID;
    }

    public void setRemoteSkeletonID(String string) {
        this.mstrSkeletonObjectID = string;
    }

    public String getRemoteMsgManagerAddress() {
        return this.mstrRemoteMsgManagerAddress;
    }

    public void setRemoteMsgManagerAddress(String string) {
        this.mstrRemoteMsgManagerAddress = string;
    }

    public long getTimeOutMilliSeconds() {
        return this.mintTimeOutSeconds;
    }

    public void setTimeOutMilliSeconds(long l) {
        this.mintTimeOutSeconds = l;
    }

    public String getStubID() {
        return this.mstrObjectID;
    }

    public void setStubID(String string) {
        this.mstrObjectID = string;
    }

    public synchronized boolean IsResultArrived(String string) {
        return this.Risultati.containsKey(string);
    }

    public synchronized CFunctionResult GetResult(String string) {
        if (this.IsResultArrived(string)) {
            CFunctionResult cFunctionResult = (CFunctionResult)this.Risultati.get(string);
            this.Risultati.remove(string);
            return cFunctionResult;
        }
        return null;
    }

    private synchronized void ResultArrived(CFunctionResult cFunctionResult) {
        this.Risultati.put(cFunctionResult.getInstanceID(), cFunctionResult);
    }

    public IDispatcher getDispatcher() {
        return this.mDispatcher;
    }

    public void setDispatcher(IDispatcher iDispatcher) {
        this.mDispatcher = iDispatcher;
    }

    public Object CallRemoteFunction(String string, boolean bl, Enumeration enumeration) throws CUnKnownSMomException, CUnKnownRemoteException, CRemoteException, CTimeOutExpiredException {
        CProcedure cProcedure = new CProcedure(string);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                cProcedure.AddParam(CValue.CreateCValue(enumeration.nextElement()));
            }
        }
        if (!this.getDispatcher().Send(cProcedure.toEnvelope(this, this.getRemoteSkeletonID()), this.getRemoteMsgManagerAddress())) {
            throw new CUnKnownSMomException("SMom.CDynamicStub", "Dispatcher couldn't Send message");
        }
        if (bl) {
            return this.HoldResult(cProcedure.getInstanceID(), this.getTimeOutMilliSeconds());
        }
        return cProcedure.getInstanceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CValue HoldResult(String string, long l) throws CUnKnownRemoteException, CRemoteException, CTimeOutExpiredException {
        Object object;
        CDynamicStub cDynamicStub = this;
        synchronized (cDynamicStub) {
            object = new Date();
            while (!this.IsResultArrived(string) && new Date().getTime() - ((Date)object).getTime() <= l) {
                try {
                    long l2 = l - (new Date().getTime() - ((Date)object).getTime());
                    System.out.println("Attendo " + l2);
                    this.wait(l2);
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        object = this.GetResult(string);
        if (object != null) {
            if (((CFunctionResult)object).IsValid()) {
                return ((CFunctionResult)object).FunctionResult;
            }
            if (((CFunctionResult)object).FunctionResult != null) {
                throw new CRemoteException("SMom.CDynamicStub", "RemoteException description:\r\n" + ((CFunctionResult)object).FunctionResult.getActualValueToString());
            }
            throw new CUnKnownRemoteException("SMom.CDynamicStub", null);
        }
        throw new CTimeOutExpiredException("SMom.CDynamicStub", "Not found Result for Request:" + string);
    }

    public String getObjectID() {
        return this.getStubID();
    }

    public synchronized void msgArrived(CEnvelope cEnvelope) {
        try {
            CFunctionResult cFunctionResult = new CFunctionResult(cEnvelope);
            this.ResultArrived(cFunctionResult);
            this.notifyAll();
        }
        catch (CCannotConvertEnvelopeToCFunctionResultException cCannotConvertEnvelopeToCFunctionResultException) {
            System.err.println(cCannotConvertEnvelopeToCFunctionResultException.toString() + "\r\nin CDynamicStub.msgArrived");
        }
    }
}

