/*
 * Decompiled with CFR 0.152.
 */
package SMom.ObjectOriented;

import SMom.CEnvelope;
import SMom.Exceptions.CCannotConvertEnvelopeToCProcedureException;
import SMom.Exceptions.CUnKnownRemoteException;
import SMom.IReceiver;
import SMom.ISender;
import SMom.ObjectOriented.CProcedure;
import SMom.ObjectOriented.Values.CValue;
import SMom.SMomUtilities;
import java.lang.reflect.Method;

public class CDynamicSkeleton
implements IReceiver,
ISender {
    private Object mServant;
    private String mstrObjectID = "CDynamicSkeleton|" + SMomUtilities.getUniqueIdentifier();

    public String getSkeletonID() {
        return this.mstrObjectID;
    }

    public void setSkeletonID(String string) {
        this.mstrObjectID = string;
    }

    public Object getServant() {
        return this.mServant;
    }

    public void setServant(Object object) {
        this.mServant = object;
    }

    public String getObjectID() {
        return this.getSkeletonID();
    }

    public void msgArrived(CEnvelope cEnvelope) {
        CProcedure cProcedure;
        try {
            cProcedure = new CProcedure(cEnvelope);
        }
        catch (CCannotConvertEnvelopeToCProcedureException cCannotConvertEnvelopeToCProcedureException) {
            System.err.println(cCannotConvertEnvelopeToCProcedureException);
            return;
        }
        try {
            Method method = this.getServant().getClass().getMethod(cProcedure.getName(), cProcedure.GetParamsClass());
            Object object = method.invoke(this.getServant(), cProcedure.GetParams());
            if (!method.getReturnType().equals(Void.TYPE)) {
                cEnvelope.Replay(cProcedure.getResponseMessage(true, CValue.CreateCValue(object)).toMsgEnvelope(), this);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            cEnvelope.Replay(cProcedure.getResponseMessage(false, CValue.CreateCValue(new CUnKnownRemoteException("SMom.CDynamicSkeleton", exception.toString()).toString())).toMsgEnvelope(), this);
        }
    }
}

