/*
 * Decompiled with CFR 0.152.
 */
package SMom.MsgManager;

import SMom.CEnvelope;
import SMom.MsgManager.CTcpManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

class CTcpManagerSlave
extends Thread {
    private CTcpManager mTcpManager;
    private Socket s;
    private PrintStream writer;
    private BufferedReader reader;
    private String mstrLastError;
    private String mstrRemoteMsgManagerAddress;

    public CTcpManagerSlave(CTcpManager cTcpManager) {
        this.mTcpManager = cTcpManager;
    }

    public CTcpManagerSlave(CTcpManager cTcpManager, Socket socket) throws IOException {
        this(cTcpManager);
        this.s = socket;
        this.openStreams(this.s);
    }

    private void openStreams(Socket socket) throws IOException {
        this.mstrRemoteMsgManagerAddress = socket.getInetAddress().getHostAddress() + ':' + String.valueOf(socket.getPort());
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.writer = new PrintStream(socket.getOutputStream());
    }

    public boolean StartConnecting(String string, int n) {
        try {
            this.s = new Socket();
            this.s.setReuseAddress(true);
            this.s.bind(new InetSocketAddress(InetAddress.getLocalHost(), this.mTcpManager.getPort()));
            this.s.connect(new InetSocketAddress(string, n));
            this.openStreams(this.s);
            return true;
        }
        catch (Exception exception) {
            this.mstrLastError = "Errore in StartConnecting " + exception.toString();
            return false;
        }
    }

    public String LastError() {
        return this.mstrLastError;
    }

    public boolean SendTCPMessage(CEnvelope cEnvelope) {
        try {
            this.writer.println(cEnvelope.toString());
            return true;
        }
        catch (Exception exception) {
            this.mstrLastError = "Errore in Scrittura: " + exception.toString();
            return false;
        }
    }

    public void run() {
        try {
            while (true) {
                String string = this.reader.readLine();
                this.OnDataArrival(string);
            }
        }
        catch (Exception exception) {
            this.mTcpManager.RemoveRemoteHost(this);
            return;
        }
    }

    private void OnDataArrival(String string) {
        try {
            CEnvelope cEnvelope = new CEnvelope(string);
            this.mTcpManager.SendToYou(cEnvelope, this.mstrRemoteMsgManagerAddress);
        }
        catch (Exception exception) {}
    }
}

