/*
 * Decompiled with CFR 0.152.
 */
package SMom.MsgManager;

import SMom.CEnvelope;
import SMom.CEnvelopeTrace;
import SMom.Dispatcher.IDispatcher;
import SMom.MsgManager.CTcpManagerSlave;
import SMom.MsgManager.IMsgManager;
import SMom.SMomUtilities;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;

public class CTcpManager
extends Thread
implements IMsgManager {
    private IDispatcher mDispatcher;
    private HashMap mManagers;
    private InetAddress mHostData = InetAddress.getLocalHost();
    private int mServerPortNumber;
    private ServerSocket mServerSocket;
    private static int mDEFAULT_PORT = 5230;
    private String mstrLastError;

    public String getLastError() {
        return this.mstrLastError;
    }

    private void setLastError(String string) {
        this.mstrLastError = string;
    }

    private void GenerateError(String string) {
        this.setLastError(string);
    }

    private void GenerateErrorGenerico(String string, Exception exception) {
        this.GenerateError("Errore non previsto in " + string + SMomUtilities.vbCrLf + exception.toString());
    }

    public IDispatcher getDispatcher() {
        return this.mDispatcher;
    }

    public void setDispatcher(IDispatcher iDispatcher) {
        this.mDispatcher = iDispatcher;
    }

    public String getAddress() {
        return this.mHostData.getHostAddress() + ':' + this.getPort();
    }

    public int getPort() {
        return this.mServerPortNumber;
    }

    public String getLocalIpAddress() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (Exception exception) {
            this.GenerateError(exception.toString());
            return "";
        }
    }

    public boolean Send(CEnvelope cEnvelope, String string) {
        if (cEnvelope.getTraceRoute() == null) {
            cEnvelope.setTraceRoute(new CEnvelopeTrace(this.getAddress()));
        } else {
            cEnvelope.getTraceRoute().setRemoteMsgManagerAddress(this.getAddress());
        }
        if (string.equalsIgnoreCase("") || string.equals(this.getAddress())) {
            if (this.getDispatcher() != null) {
                return this.getDispatcher().msgArrived(cEnvelope);
            }
        } else {
            CTcpManagerSlave cTcpManagerSlave = this.FindPeerServer(string);
            if (cTcpManagerSlave == null) {
                int n;
                cTcpManagerSlave = new CTcpManagerSlave(this);
                String string2 = string.substring(0, string.indexOf(58));
                if (!cTcpManagerSlave.StartConnecting(string2, n = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length())))) {
                    System.err.println(this.getAddress() + " Cannot Connect to " + string + "due to " + cTcpManagerSlave.LastError());
                    this.GenerateError("Error in Send:" + SMomUtilities.vbCrLf + cTcpManagerSlave.LastError());
                    return false;
                }
                cTcpManagerSlave.start();
                this.mManagers.put(string, cTcpManagerSlave);
            }
            return cTcpManagerSlave.SendTCPMessage(cEnvelope);
        }
        return false;
    }

    protected void RemoveRemoteHost(CTcpManagerSlave cTcpManagerSlave) {
        this.mManagers.remove(cTcpManagerSlave);
        cTcpManagerSlave.stop();
        cTcpManagerSlave.destroy();
        cTcpManagerSlave = null;
    }

    private CTcpManagerSlave FindPeerServer(String string) {
        if (this.mManagers.containsKey(string)) {
            return (CTcpManagerSlave)this.mManagers.get(string);
        }
        return null;
    }

    protected boolean SendToYou(CEnvelope cEnvelope, String string) {
        if (this.getDispatcher() != null) {
            if (cEnvelope.getTraceRoute() == null) {
                cEnvelope.setTraceRoute(new CEnvelopeTrace());
            }
            cEnvelope.getTraceRoute().setLocalMsgManager(this);
            cEnvelope.getTraceRoute().setRemoteMsgManagerAddress(string);
            return this.getDispatcher().msgArrived(cEnvelope);
        }
        return false;
    }

    public int getKnownManagerNumber() {
        return this.mManagers.size();
    }

    public boolean StartListenforMessages() {
        try {
            this.start();
            return true;
        }
        catch (Exception exception) {
            this.GenerateError(exception.toString());
            return false;
        }
    }

    public void run() {
        try {
            this.mServerSocket = new ServerSocket(this.getPort());
            System.out.println("CTcpManager in ascolto su porta " + this.getPort());
            while (true) {
                System.out.println("Server pronto per la richiesta...");
                Socket socket = this.mServerSocket.accept();
                CTcpManagerSlave cTcpManagerSlave = new CTcpManagerSlave(this, socket);
                this.mManagers.put(socket.getInetAddress().getHostAddress() + ':' + socket.getPort(), cTcpManagerSlave);
                cTcpManagerSlave.start();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StopListenforMessages() {
        if (this.mServerSocket != null) {
            try {
                try {
                    this.stop();
                    this.mServerSocket.close();
                }
                catch (Exception exception) {
                    this.GenerateError(exception.toString());
                    Object var3_2 = null;
                    this.mServerSocket = null;
                }
                Object var3_1 = null;
                this.mServerSocket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.mServerSocket = null;
                throw throwable;
            }
        }
    }

    public CTcpManager(int n) throws UnknownHostException {
        this.mServerPortNumber = n;
        this.mManagers = new HashMap();
    }

    public CTcpManager() throws UnknownHostException {
        this(mDEFAULT_PORT);
    }
}

