/*
 * Decompiled with CFR 0.152.
 */
package SMom.MsgManager;

import SMom.CEnvelope;
import SMom.CEnvelopeTrace;
import SMom.Dispatcher.IDispatcher;
import SMom.MsgManager.IMsgManager;
import SMom.SMomUtilities;
import java.util.Vector;

public class CLocalManager
implements IMsgManager {
    private IDispatcher mDispatcher;
    private Vector mManagers;
    private String mAddress = "LocalManager|" + SMomUtilities.getUniqueIdentifier();

    public IDispatcher getDispatcher() {
        return this.mDispatcher;
    }

    public void setDispatcher(IDispatcher iDispatcher) {
        this.mDispatcher = iDispatcher;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public boolean Send(CEnvelope cEnvelope, String string) {
        int n = 0;
        if (cEnvelope.getTraceRoute() == null) {
            cEnvelope.setTraceRoute(new CEnvelopeTrace(this.getAddress()));
        } else {
            cEnvelope.getTraceRoute().setRemoteMsgManagerAddress(this.getAddress());
        }
        if (string == null || string.equalsIgnoreCase("") || string.equals(this.getAddress())) {
            return this.SendToYou(cEnvelope);
        }
        n = 0;
        while (n < this.mManagers.size()) {
            CLocalManager cLocalManager = (CLocalManager)this.mManagers.elementAt(n);
            if (cLocalManager.getAddress().equals(string)) {
                return cLocalManager.SendToYou(cEnvelope);
            }
            ++n;
        }
        return false;
    }

    protected boolean SendToYou(CEnvelope cEnvelope) {
        if (this.getDispatcher() != null) {
            if (cEnvelope.getTraceRoute() == null) {
                cEnvelope.setTraceRoute(new CEnvelopeTrace());
            }
            cEnvelope.getTraceRoute().setLocalMsgManager(this);
            return this.getDispatcher().msgArrived(cEnvelope);
        }
        return false;
    }

    public int getKnownManagerNumber() {
        return this.mManagers.size();
    }

    public boolean Register(CLocalManager cLocalManager) {
        this.mManagers.addElement(cLocalManager);
        return true;
    }

    public boolean UnRegister(CLocalManager cLocalManager) {
        this.mManagers.removeElement(cLocalManager);
        return true;
    }

    public int IsRegistered(CLocalManager cLocalManager) {
        return this.mManagers.indexOf(cLocalManager);
    }

    public CLocalManager() {
        this.mManagers = new Vector();
    }
}

