/*,
 * Created on 4-giu-2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package client;

import DFSS.Directory;
import DFSS.HostID;
import DFSS.IClientCallBack;
import DFSS.IDistributedFileSystemService;
import Gui.*;
import java.rmi.*;
import java.io.*;
/**
 * @author Dario Agostinone
 *
 * Cliente che avvia l'interfaccia grafica 
 * 
 */
public class Client extends java.rmi.server.UnicastRemoteObject  implements IClientCallBack {
	
  protected MyStartDialog avvio;
  protected HostID registryHost;
  protected String home;
  
   public Client( HostID host , String home) throws RemoteException
   {
   	super();
	avvio = new MyStartDialog();
	registryHost=host;
	this.home=home;
   }
   

	public static void main(String[] args) {
		try
		{
			final int REGISTRYPORT = 1099; 
			// essendo la porta di default non sarebbe necessario specificarla
			BufferedReader in = new BufferedReader(new InputStreamReader(System.in));			
			// letto da linea di comando, coincide con l'host su cui  in esecuzione il server		
			String completeName;		
			// Controllo dei parametri della riga di comando
			if (args.length != 3)
				{ System.out.println("Sintassi: client.client nodo ip homedir"); System.exit(1); }
			HostID host = new HostID(args[0],args[1]);
			Client cl = new Client(host,args[2]); 
			// Impostazione del SecurityManager
		  	if (System.getSecurityManager() == null)
				{ 
						System.setSecurityManager(new RMISecurityManager()); 
				}
			// Connessione al servizio RMI remoto
		  	completeName = "//" + host.getIP() + ":" + REGISTRYPORT + "/" + host.getNome();
	      	IDistributedFileSystemService  f= (IDistributedFileSystemService)Naming.lookup(completeName);
	    	System.out.println("accedo al server");
	     	f.getDirectory("ALL",cl);
			}catch (Exception e)
			{
				System.out.println("errore"+e.getMessage());
	    	}
	}
	
	public void Error(Exception e) throws RemoteException 
	{
	   System.out.println(e.toString());
	}
	
	public void CallBack(Object in) throws RemoteException
	{
	 try
	 {
	  avvio.dispose();
	  ClientGui gui = new ClientGui((Directory) in,registryHost,home );	
	 }catch (Exception e ){ e.printStackTrace();}
	}
}
