/*
 * Created on 5-lug-2004
 *
 * 
 */
package Operations;

import DFSS.*;
import FRS.*;

/**
 * @author Dario Agostinone
 *
 *    Invia una riciesta di scrittura ala repository server
 * 
 */
public class DFSSscriviFile implements IOperazione {
 		// path del file
	    protected String path ;
	    //repository
		protected IFileRepositoryServer repository;
		//datamanager locale
		protected Datamanager data;
		protected static boolean isvoid = true;
		// cliente 
		protected IClientCallBack client;
		// restituisce l'esito dell'operazione
		protected boolean ready;
		protected String ErrorMessage;
		protected boolean append;
		protected String dir;
		protected String file;
        
        
        /**
         * 
         * 
         * 
         * Costruttore
         */
		public DFSSscriviFile(String nome,boolean append,IClientCallBack client,IFileRepositoryServer rep,Datamanager data)
		{
			this.client=client;
			path=nome;
			repository=rep;
			this.append=append;
			this.data=data;
			ready=false;
			int pos=path.lastIndexOf("/");
			dir = path.substring(0,pos);
			file = path.substring(pos+1,path.length());
		    ErrorMessage="";
		}
		
		
		/**
		* 
		* Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
		*
		*/
		public String getError()
	 	{
	   		return ErrorMessage;
	 	}
		/**
		 * 
		 * validazione dell'operazione
		 * 
		 */
	    public boolean valida()
			  {
			   return data.ExistsFile(dir,file);
			  }
		/**
		 * 
		 *  effettua l'operazione
		 * 
		 */
		public void applica() {
			
			try
			{   // accede all'id del file e inoltra la richiesta al repository
				String  pathid = data.getIdFile(dir,file);
			   	repository.accediInScrittura(pathid,append,client);
				ready=true;
			}catch(Exception e)
			{
				ready=false;
				ErrorMessage="Errore nell'operazione di accesso al file "+e.toString();
			}
			
		}


		/* (non-Javadoc)
		 * @see DFSS.IOperazione#isVoid()
		 */
		public boolean isVoid() {
			
			return isvoid;
		}

		/**
		 * 
		 * 
		 * Callback del cliente
		 */
		public IClientCallBack getClient() {
			
			return client;
		}

		/**
		 * Resituisce l'esito dell'operazione
		 * 
		 */
		public boolean ready() {
			
			return ready;
		}

		/**
		 * 
		 *  Restituisce il risultato dell'operazione
		 * 
		 */
		public Object getRisultato() {
		
			return null;
		}
}
