/*
 * Created on 2-lug-2004
 *
 * 
 */
package Operations;

import DFSS.*;
import FRS.*;

/**
 * @author Dario Agostinone
 *
 *    Eliminazione di un file
 * 
 */
public class DFSSRimuoviFile implements IOperazione {


        // rifeirmento remoto al repository server
	    protected IFileRepositoryServer repository;
	    //path del file
		protected String path;
		//callback
		protected IClientCallBack client;
		protected static boolean isVoid =false;
		//esito dell'operazione
		protected boolean ready ;
		//risultato dell'operazione
		protected boolean risultato;
		// datamanager
		protected Datamanager data;
		// message manager
		protected MessageManager msgManager;
		protected String ErrorMessage;
		protected String dir;
		protected String file;
		
		public DFSSRimuoviFile( IFileRepositoryServer rep,String path,IClientCallBack client,MessageManager msg,Datamanager data)
		{
			repository=rep;
			this.path = path ;
			this.client=client;
			this.data =data;
			ready=false;
			risultato =false;
			ErrorMessage="";
			msgManager=msg;
			int pos=path.lastIndexOf("/");
			dir = path.substring(0,pos);
			file = path.substring(pos+1,path.length());
		}

	/**
	* 
	* Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
	*
	*/
	public String getError()
	 {
	   return ErrorMessage;
	 }
    /**
     * 
     * Validazione delloperazione
     * 
     */
	public boolean valida()
		  {
		   return data.ExistsFile(dir,file);
		  }

	/**
	 * 
	 * esegue l'operazione
	 * 
	 */
	public void applica() {
		
		try
		{
		   // accede alla cartella
		   Directory d = data.getDirectory(dir);
		   //preleva l'identificativo del file
		   String pathid=d.getFileId(file);
		   if (path==null) risultato=false;
		   else
		   {
		   	//elimina il file
		   	repository.eliminaFile(path);		  		   
		   	System.out.println("Rimuovi il file "+file+" nella cartella "+dir);
		   	//elimina logicamente il file
		   	data.rimuoviFile(dir,file);
		   	//propaga la modifica
		   	msgManager.removeFile(dir,file);
		   	risultato=true;
		   }
		   ready=true;
		}catch (Exception e)
		{
			risultato=false;
			ready=false;
			ErrorMessage= "Errore durante l'eliminazione del file "+e.toString();
		}
	}



	/**
	 *  restituisce il valore isVoid
	 * 
	 */
	public boolean isVoid() {
	
		return isVoid;
	}

	/**
	 * 
	 *  restituisce il callback
	 * 
	 */
	public IClientCallBack getClient() {
		
		return client;
	}

	/**
	 * 
	 * Restituisce l'esito dell'operazione
	 * 
	 * 
	 */
	public boolean ready() {
		
		return ready;
	}

	/**
	 * 
	 *  restiuisce il risultato dell'operazione
	 * 
	 * 
	 */
	public Object getRisultato() {
		
		return new Boolean(risultato);
	}

}
