/*
 * Created on 5-lug-2004
 *
 * 
 */
package Operations;

import DFSS.*;
import FRS.*;

/**
 * @author Dario Agostinone
 *
 *     Permette di inoltrare una richiesta d'accesso al file
 * 
 */
public class DFSSLeggiFile implements IOperazione {

	    // path del file
	    protected String path ;
	    //repository
		protected IFileRepositoryServer repository;
		//datamanager locale
		protected Datamanager data;
		protected static boolean isvoid = true;
		//client 
		protected IClientCallBack client;
		// esito dell'operazione
		protected boolean ready;
		protected String ErrorMessage;
		protected String dir;
		protected String file;
		
    
		public DFSSLeggiFile(String nome,IClientCallBack client,IFileRepositoryServer rep,Datamanager data)
		{
			//inizializzazione
			this.client=client;
			path=nome;
			repository=rep;
			this.data=data;
			ready=false;
			int pos=path.lastIndexOf("/");
			dir = path.substring(0,pos);
			file = path.substring(pos+1,path.length());
			ErrorMessage="";
		}
		
		/**
		 * 
		 * 
		 * Validazione dell'operazione
		 */
	    public boolean valida()
			  {
			   return data.ExistsFile(dir,file);
			  }

		/**
		* 
		* Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
		*
		*/
		public String getError()
	 	{
	   		return ErrorMessage;
	 	}
		/**
		 * 
		 *  esegue l'operazione
		 */
		public void applica() {
			try
			{
				String  pathid = data.getIdFile(dir,file);
			   	repository.accediInLettura(pathid,client);
			   	ready=true;
			}catch(Exception e)
			{
				ready=false;
				ErrorMessage=" Richiesta non eseguita "+e.toString();
			}
		}


		/**
		 * 
		 * restituisc isVoid
		 * 
		 */
		public boolean isVoid() {
		
			return isvoid;
		}

        /**
         * 
         * Resituisce il callbakc del cliente
         * 
         */
		public IClientCallBack getClient() {
			
			return client;
		}

		/**
		 * 
		 * Restiuisce l'esito dell'operazione
		 * 
		 */
		public boolean ready() {
			
			return ready;
		}

		/**
		 * 
		 *  restituisce il risultato null, per le istanze di questa classe
		 *  
		 * 
		 */
		public Object getRisultato() {
			
			return null;
		}
}