/*
 * Created on 6-giu-2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package Operations;

import DFSS.*;
import java.io.*;
/**
 * @author Dario Agostinone
 *
 * Acecde al contenuto di una cartella
 * 
 */
public class DFSSGetDirectory implements IOperazione,Serializable {

    //ha valore true se l'operazione  stat effettuata con successo
    protected boolean ready;
   
    //risultato dell'operazione
    protected Directory result;
    
    //path della cartella
    protected String  path;
    
    //cliente
    protected IClientCallBack client;
    
    protected static boolean isvoid= false;
    //datamanager locale
    protected Datamanager data;
    //eventuale mesaggio di errore
    protected String ErrorMessage ;
    
    /**
     * 
     * 
     * Costruttore
     */
    public DFSSGetDirectory(String path ,IClientCallBack client,Datamanager data )
    {
    	ready=false;
    	this.client=client;
    	this.path=path;
        this.data=data;
    }
    
    
	/**
    * 
	* Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
	*
	*/
	public String getError()
	 {
	   return ErrorMessage;
	 }
    /**
     * 
     *  restituisce l'esito dell'operazione
     */
	public boolean ready()
	   {
		return ready;
	   }
    /**
     * 
     * Validazione dell'operazione
     * 
     */
	public boolean valida()
		  {
		   return data.ExistsDir(path);
		  }
 
    /**
     * 
     *  resituisce il callback del cliente
     * 
     */
	public IClientCallBack getClient()
		  {
			return client;
		  }
	  
	/**
	 * 
	 * Esegue l'operazione
	 */
	public void applica() {
		
		try
		  {
		   result =  data.getDirectory(path);
		   ready=true; 
		  }catch (Exception e)
		  {
		   ready=false;
		   ErrorMessage=" Errore nell'accesso alla cartella "+e.toString();
		  }
	}
	
	/**
	 * 
	 * Restituisce il valore di isVoid
	 * 
	 */
	public boolean isVoid() {
		
		return isvoid;
	}

	/**
	 * 
	 * Resituisce il risultato
	 * 
	 */
	public Object getRisultato() {
		
		return result;
	}

}
