/*
 * Created on 4-giu-2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package Operations;

import DFSS.*;
import java.io.*;
import FRS.*;
import java.util.*;

/**
 * @author Dario Agostinone
 *
 * 
 * Eliminazione di una cartella
 */
public class DFSSEliminaDirectory implements IOperazione,Serializable {

    // ready = true se l'operazione  stata effettuata con successo
    protected boolean ready;
    // path della directory da creare
    protected String path ;
	protected static boolean isvoid = false;
	//Cliente
    protected IClientCallBack client ;
    //risultato atteso 
	protected boolean risultato;
	//eventuale messaggio di errore
	protected String ErrorMessage;
	//datamanager locale
	protected Datamanager data;
	//file repository
	protected IFileRepositoryServer repository;
	//Message Manager
	protected MessageManager msgManager;
	
	/**
	 * 
	 * 
	 * Costruttore
	 */
    public DFSSEliminaDirectory( String path ,IClientCallBack cl,MessageManager msg,IFileRepositoryServer rep ,Datamanager data)
    {
    	//inizializzazione
    	this.path=path;
        client=cl;
    	ready = false;
    	repository=rep;
    	this.data=data;
    	msgManager = msg;
    	ErrorMessage="";
    }
    
	/**
	  * 
	  * Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
	  *
    */
	public String getError()
		  {
		   return ErrorMessage;
		  }
	
	/**
	 * 
	 *  resituisce l'esito dell'operazione
	 */
    public boolean ready()
    {
    	return ready;
    }
    
    /**
     * restiruisce il callback del cliente
     */
    
	public IClientCallBack getClient()
	  {
		return client;
	  }
	  
	/**
	 * Esegue l'operazione
	 * 
	 */
	public void applica() {
		
		try
		   {
		   	//carico la directory ( Tutte le informazioni logiche)
		   	Directory dir = data.getDirectory(path);
		   	//rimuovo la directory 
			removeDir(dir);
			msgManager.removeDirectory(path);
			ready=true;
			risultato=true;
		   }catch (Exception e)
		   {
		   	 ready=false;
			 ErrorMessage ="Errore durante l'eliminazione della cartella"+e.toString();
		     risultato=false;
		   }    
	}
	
	/**
	 * 
	 * rimuove la cartella dir
	 *
	 */
	private void removeDir (Directory dir) throws Exception
	{
			    //elimino le sottodirectory
			    Enumeration dirs = dir.getSottoDirectory();
			    while(dirs.hasMoreElements())
			    {
			    	removeDir((Directory)dirs.nextElement());
			    }
			    //elimino i file dal repository
				Enumeration files = dir.getIDs();
				while(files.hasMoreElements())
						{
							repository.eliminaFile((String)files.nextElement());
						}
				data.removeDirectory(dir.getPath());
	
	}
	
	
	/**
	 * 
	 * restituisce il risultato
	 */
	public Object getRisultato()
	{
		return new Boolean(risultato); 
	}
	
	/**
	 * 
	 * Effettuo la validazione dell'operazione
	 * 
	 */
	public boolean valida()
		  {
		   return data.ExistsDir(path);
		  }

	
	/**
	 * 
	 *  restituisce iil valore di isVoid
	 * 
	 */
	public boolean isVoid()
	{
		return isvoid;
	}
	

}
