/*
 * Created on 2-lug-2004
 *
 * 
 */
package Operations;


import FRS.*;

import DFSS.*;
/**
 * @author Dario Agostinone
 *
 *   Operazione di creazione di un file
 * 
 */
public class DFSSCreaFile implements IOperazione {

    // file repository
	protected IFileRepositoryServer repository;
	//path del file da creare
	protected String path;
	//cliente
	protected IClientCallBack client;
	protected static boolean isVoid =false;
	// ready = true se l'operazione  stata effettuata con successo
	protected boolean ready ;
	// risultato dell'operazione
	protected boolean risultato;
	// datamanager locale
	protected Datamanager data;
	// message Manager
	protected MessageManager msgManager;
	// Eventuale messaggio di errore
	protected String ErrorMessage; 
	// variabile temporanee
	protected String file,dir;
	
	/**
	 * 
	 * Costruttore
	 */
    public DFSSCreaFile( IFileRepositoryServer rep,String path,IClientCallBack client,MessageManager msgMan,Datamanager data)
    {
    	// inizializzazione dell'operazione
    	repository=rep;
    	this.path = path ;
    	msgManager= msgMan;
    	this.client=client;
    	this.data =data;
    	ready=false;
    	risultato =false;
		int pos=path.lastIndexOf("/");
		dir = path.substring(0,pos);
		 file = path.substring(pos+1,path.length());
		 ErrorMessage="";
    }
    
    
	/**
	   * 
	   * Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
	   *
	   */
	public String getError()
	  {
	   return ErrorMessage;
	  }
   
   /**
    * 
    * effettua la validazione dell'operazione
    */
    public boolean valida()
    {
    	return !data.ExistsFile(dir,file);
    }
	
	/**
	 * 
	 * 
	 * Esegue l'operazione
	 */
	public void applica() {
	try
	{
	   // crea la cartella
       risultato = repository.creaFile(path);
       if (risultato)
       {// possibile creare il file
       	System.out.println("Creo il file "+file+" nella cartella "+dir);
       	data.addFile(dir,file,path);
	   	msgManager.newFile(dir,file,path);
		ready=true;
       }
	}catch (Exception e)
	{
		ready=false;
		ErrorMessage= "Errore duranta la creazione del file "+e;
	    risultato=false;
	}
	  
	 
	}
	

/**
 * 
 * restituisce il valore di isVoid
 */
	public boolean isVoid() {
		
		return DFSSCreaFile.isVoid;
	}

	/**
	 * 
	 * restituisce il callback del cliente
	 */
	public IClientCallBack getClient() {
		
		return client;
	}

	/**
	 * 
	 * restituisce l'esito del''operazione
	 * 
	 */
	public boolean ready() {
		
		return ready;
	}

    /**
     * 
     * 
     * resituisce il risultato dell'operazione
     */
	public Object getRisultato() {
		
		return new Boolean(risultato);
	}

}
