/*
 * Created on 3-giu-2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package Operations;

import DFSS.*;
import java.io.*;
/**
 * @author Dario Agostinone
 *
 * Operazione di creazione di una cartella
 * 
 */
public class DFSSCreaDirectory implements IOperazione,Serializable{

   // path della cartella
   protected String path ;
   // ready = true se l'operazione  stata eseguita con successo
   protected boolean ready;
   protected static boolean isvoid = false;
   // risultato true se  stata creata la cartella
   protected boolean risultato;
   //gestore dei messaggi
   protected MessageManager msgManager;
   // cliente
   protected IClientCallBack cliente;
   // datamanager che gestisce la memorizzazione delle informazioni sui file e lecartelle
   protected Datamanager data;
   // messaggio di errore, vuoto se non ci sono errori
   protected String ErrorMessage;
   
   /**
    * 
    * 
    * Costruttore
    */
   public DFSSCreaDirectory(String path,IClientCallBack cl,MessageManager in,Datamanager data)
   {
   	   ready=false;
   	   msgManager=in;
   	   this.path=path;
   	   cliente=cl;
   	   this.data=data;
   	   ErrorMessage="";
   }
   
   /**
    * 
    * Restituisce il messaggio di errore, se non vi sono errori restituisce una stringa vuota
    *
    */
   public String getError()
   {
   	return ErrorMessage;
   }
   
   /**
    * 
    * effettua la validazione dell'operazione
    */
   
   public boolean valida()
   {
   	return !data.ExistsDir(path);
   }

   /**
    * 
    * Restituisce il valore di isVoid
    */
   public boolean isVoid()
   {
   	return isvoid;
   }
   
   /**
    * 
    * restituisce il cliente , null se l'operazione non prevede un risultato
    */
   public IClientCallBack getClient()
   {
   	 return cliente;
   }
   
   /**
    *  Restituisce il risultato, null se isVoid =true
    * 
    */
   public Object getRisultato()
   {
   	return new Boolean( risultato);
   }
   
   /**
    * 
    * Resituisce il valore di ready
    */
   public boolean ready()
   {
   	return ready;
   }
   
   /**
    * 
    * Esegue l'operazione
    */
   public void applica()
   {
   	       // creo l'oggetto directory associato al path
           Directory nuova = new Directory(path);
		   try
		   {
		   	//memorizzo la directory
			data.saveDirectory(nuova);
			//propago l'operazione
			msgManager.newDirectory(path);
		    risultato=true;
			ready=true;
		   }catch (Exception e)
		   {
		   	ready=false;
		   	ErrorMessage = " Errore durante la creazione della nuova cartella"+e.toString(); 
		    risultato = false;
		   }
	       
   };
}
